/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cms;

import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import shaded.cfca.sadk.org.bouncycastle.operator.ContentVerifier;
import shaded.cfca.sadk.org.bouncycastle.operator.ContentVerifierProvider;
import shaded.cfca.sadk.org.bouncycastle.operator.DigestCalculator;
import shaded.cfca.sadk.org.bouncycastle.operator.DigestCalculatorProvider;
import shaded.cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import shaded.cfca.sadk.org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;

public class SignerInformationVerifier {
    private ContentVerifierProvider verifierProvider;
    private DigestCalculatorProvider digestProvider;
    private SignatureAlgorithmIdentifierFinder sigAlgorithmFinder;
    private CMSSignatureAlgorithmNameGenerator sigNameGenerator;

    public SignerInformationVerifier(CMSSignatureAlgorithmNameGenerator sigNameGenerator, SignatureAlgorithmIdentifierFinder sigAlgorithmFinder, ContentVerifierProvider verifierProvider, DigestCalculatorProvider digestProvider) {
        this.sigNameGenerator = sigNameGenerator;
        this.sigAlgorithmFinder = sigAlgorithmFinder;
        this.verifierProvider = verifierProvider;
        this.digestProvider = digestProvider;
    }

    public boolean hasAssociatedCertificate() {
        return this.verifierProvider.hasAssociatedCertificate();
    }

    public X509CertificateHolder getAssociatedCertificate() {
        return this.verifierProvider.getAssociatedCertificate();
    }

    public ContentVerifier getContentVerifier(AlgorithmIdentifier signingAlgorithm, AlgorithmIdentifier digestAlgorithm) throws OperatorCreationException {
        String signatureName = this.sigNameGenerator.getSignatureName(digestAlgorithm, signingAlgorithm);
        return this.verifierProvider.get(this.sigAlgorithmFinder.find(signatureName));
    }

    public DigestCalculator getDigestCalculator(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        return this.digestProvider.get(algorithmIdentifier);
    }
}

