/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERSet;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.Attribute;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.AttributeTable;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.CMSAttributes;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSAttributeTableGenerator;

public class DefaultAuthenticatedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultAuthenticatedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultAuthenticatedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map parameters) {
        Attribute attr;
        Hashtable std = new Hashtable();
        Enumeration en = this.table.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            std.put(key, this.table.get(key));
        }
        if (!std.containsKey(CMSAttributes.contentType)) {
            ASN1ObjectIdentifier contentType = ASN1ObjectIdentifier.getInstance(parameters.get("contentType"));
            attr = new Attribute(CMSAttributes.contentType, new DERSet(contentType));
            std.put(attr.getAttrType(), attr);
        }
        if (!std.containsKey(CMSAttributes.messageDigest)) {
            byte[] messageDigest = (byte[])parameters.get("digest");
            attr = new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(messageDigest)));
            std.put(attr.getAttrType(), attr);
        }
        return std;
    }

    public AttributeTable getAttributes(Map parameters) {
        return new AttributeTable(this.createStandardAttributeTable(parameters));
    }
}

