/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.AuthEnvelopedData;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.OriginatorInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSEnvelopedHelper;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSException;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSSecureReadable;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSUtils;
import shaded.cfca.sadk.org.bouncycastle.cms.RecipientInformationStore;

class CMSAuthEnvelopedData {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private OriginatorInfo originator;
    private AlgorithmIdentifier authEncAlg;
    private ASN1Set authAttrs;
    private byte[] mac;
    private ASN1Set unauthAttrs;

    public CMSAuthEnvelopedData(byte[] authEnvData) throws CMSException {
        this(CMSUtils.readContentInfo(authEnvData));
    }

    public CMSAuthEnvelopedData(InputStream authEnvData) throws CMSException {
        this(CMSUtils.readContentInfo(authEnvData));
    }

    public CMSAuthEnvelopedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        AuthEnvelopedData authEnvData = AuthEnvelopedData.getInstance(contentInfo.getContent());
        this.originator = authEnvData.getOriginatorInfo();
        ASN1Set recipientInfos = authEnvData.getRecipientInfos();
        EncryptedContentInfo authEncInfo = authEnvData.getAuthEncryptedContentInfo();
        this.authEncAlg = authEncInfo.getContentEncryptionAlgorithm();
        CMSSecureReadable secureReadable = new CMSSecureReadable(){

            public InputStream getInputStream() throws IOException, CMSException {
                return null;
            }
        };
        this.recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, this.authEncAlg, secureReadable);
        this.authAttrs = authEnvData.getAuthAttrs();
        this.mac = authEnvData.getMac().getOctets();
        this.unauthAttrs = authEnvData.getUnauthAttrs();
    }
}

