/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cert.crmf.test;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.EncKeyWithID;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.EncryptedValue;
import shaded.cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.GeneralName;
import shaded.cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.EncryptedValueBuilder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.EncryptedValuePadder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.EncryptedValueParser;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.PKIArchiveControl;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.PKMACBuilder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.ValueDecryptorGenerator;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.bc.BcFixedLengthMGF1Padder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.jcajce.JcaCertificateRequestMessage;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.jcajce.JcaCertificateRequestMessageBuilder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.jcajce.JcaEncryptedValueBuilder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.jcajce.JcaPKIArchiveControlBuilder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.jcajce.JceAsymmetricValueDecryptorGenerator;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.jcajce.JceCRMFEncryptorBuilder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.jcajce.JcePKMACValuesCalculator;
import shaded.cfca.sadk.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import shaded.cfca.sadk.org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSAlgorithm;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import shaded.cfca.sadk.org.bouncycastle.cms.RecipientInformation;
import shaded.cfca.sadk.org.bouncycastle.cms.RecipientInformationStore;
import shaded.cfca.sadk.org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import shaded.cfca.sadk.org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import shaded.cfca.sadk.org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import shaded.cfca.sadk.org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import shaded.cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import shaded.cfca.sadk.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import shaded.cfca.sadk.org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import shaded.cfca.sadk.org.bouncycastle.operator.jcajce.JceAsymmetricKeyWrapper;
import shaded.cfca.sadk.org.bouncycastle.util.Arrays;

public class AllTests
extends TestCase {
    private static final byte[] TEST_DATA = "Hello world!".getBytes();
    private static final String BC = "BC";
    private static final String PASSPHRASE = "hello world";

    public AllTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)AllTests.class);
    }

    public static Test suite() {
        return new TestSuite(AllTests.class);
    }

    public void setUp() {
        Security.addProvider(new BouncyCastleProvider());
    }

    public void tearDown() {
    }

    public void testBasicMessageWithArchiveControl() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509Certificate cert = AllTests.makeV1Certificate(kp, "CN=Test", kp, "CN=Test");
        JcaCertificateRequestMessageBuilder certReqBuild = new JcaCertificateRequestMessageBuilder(BigInteger.ONE);
        certReqBuild.setSubject(new X500Principal("CN=Test")).setPublicKey(kp.getPublic());
        certReqBuild.addControl(new JcaPKIArchiveControlBuilder(kp.getPrivate(), new X500Principal("CN=Test")).addRecipientGenerator(new JceKeyTransRecipientInfoGenerator(cert).setProvider(BC)).build(new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(CMSEnvelopedDataGenerator.AES128_CBC)).setProvider(BC).build()));
        JcaCertificateRequestMessage certReqMsg = new JcaCertificateRequestMessage(certReqBuild.build());
        AllTests.assertEquals((Object)new X500Principal("CN=Test"), (Object)certReqMsg.getSubjectX500Principal());
        AllTests.assertEquals((Object)kp.getPublic(), (Object)certReqMsg.getPublicKey());
        PKIArchiveControl archiveControl = (PKIArchiveControl)certReqMsg.getControl(CRMFObjectIdentifiers.id_regCtrl_pkiArchiveOptions);
        AllTests.assertEquals((int)0, (int)archiveControl.getArchiveType());
        AllTests.assertTrue((boolean)archiveControl.isEnvelopedData());
        RecipientInformationStore recips = archiveControl.getEnvelopedData().getRecipientInfos();
        JceKeyTransRecipientId recipientId = new JceKeyTransRecipientId(cert);
        RecipientInformation recipientInformation = recips.get(recipientId);
        AllTests.assertNotNull((Object)recipientInformation);
        EncKeyWithID encKeyWithID = EncKeyWithID.getInstance(recipientInformation.getContent(new JceKeyTransEnvelopedRecipient(kp.getPrivate()).setProvider(BC)));
        AllTests.assertTrue((boolean)encKeyWithID.hasIdentifier());
        AllTests.assertFalse((boolean)encKeyWithID.isIdentifierUTF8String());
        AllTests.assertEquals((Object)new GeneralName(X500Name.getInstance(new X500Principal("CN=Test").getEncoded())), (Object)encKeyWithID.getIdentifier());
        AllTests.assertTrue((boolean)Arrays.areEqual(kp.getPrivate().getEncoded(), encKeyWithID.getPrivateKey().getEncoded()));
    }

    public void testProofOfPossessionWithoutSender() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509Certificate cert = AllTests.makeV1Certificate(kp, "CN=Test", kp, "CN=Test");
        JcaCertificateRequestMessageBuilder certReqBuild = new JcaCertificateRequestMessageBuilder(BigInteger.ONE);
        certReqBuild.setPublicKey(kp.getPublic()).setAuthInfoPKMAC(new PKMACBuilder(new JcePKMACValuesCalculator()), "fred".toCharArray()).setProofOfPossessionSigningKeySigner(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(kp.getPrivate()));
        certReqBuild.addControl(new JcaPKIArchiveControlBuilder(kp.getPrivate(), new X500Principal("CN=test")).addRecipientGenerator(new JceKeyTransRecipientInfoGenerator(cert).setProvider(BC)).build(new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(CMSEnvelopedDataGenerator.AES128_CBC)).setProvider(BC).build()));
        JcaCertificateRequestMessage certReqMsg = new JcaCertificateRequestMessage(certReqBuild.build().getEncoded());
        try {
            certReqMsg.isValidSigningKeyPOP(new JcaContentVerifierProviderBuilder().setProvider(BC).build(kp.getPublic()));
            AllTests.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        AllTests.assertTrue((boolean)certReqMsg.isValidSigningKeyPOP(new JcaContentVerifierProviderBuilder().setProvider(BC).build(kp.getPublic()), new PKMACBuilder(new JcePKMACValuesCalculator().setProvider(BC)), "fred".toCharArray()));
        AllTests.assertEquals((Object)kp.getPublic(), (Object)certReqMsg.getPublicKey());
    }

    public void testProofOfPossessionWithSender() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509Certificate cert = AllTests.makeV1Certificate(kp, "CN=Test", kp, "CN=Test");
        JcaCertificateRequestMessageBuilder certReqBuild = new JcaCertificateRequestMessageBuilder(BigInteger.ONE);
        certReqBuild.setPublicKey(kp.getPublic()).setAuthInfoSender(new X500Principal("CN=Test")).setProofOfPossessionSigningKeySigner(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(kp.getPrivate()));
        certReqBuild.addControl(new JcaPKIArchiveControlBuilder(kp.getPrivate(), new X500Principal("CN=test")).addRecipientGenerator(new JceKeyTransRecipientInfoGenerator(cert).setProvider(BC)).build(new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(CMSEnvelopedDataGenerator.AES128_CBC)).setProvider(BC).build()));
        JcaCertificateRequestMessage certReqMsg = new JcaCertificateRequestMessage(certReqBuild.build().getEncoded());
        try {
            certReqMsg.isValidSigningKeyPOP(new JcaContentVerifierProviderBuilder().setProvider(BC).build(kp.getPublic()), new PKMACBuilder(new JcePKMACValuesCalculator().setProvider(BC)), "fred".toCharArray());
            AllTests.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        AllTests.assertTrue((boolean)certReqMsg.isValidSigningKeyPOP(new JcaContentVerifierProviderBuilder().setProvider(BC).build(kp.getPublic())));
        AllTests.assertEquals((Object)kp.getPublic(), (Object)certReqMsg.getPublicKey());
    }

    public void testProofOfPossessionWithTemplate() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509Certificate cert = AllTests.makeV1Certificate(kp, "CN=Test", kp, "CN=Test");
        JcaCertificateRequestMessageBuilder certReqBuild = new JcaCertificateRequestMessageBuilder(BigInteger.ONE);
        certReqBuild.setPublicKey(kp.getPublic()).setSubject(new X500Principal("CN=Test")).setAuthInfoSender(new X500Principal("CN=Test")).setProofOfPossessionSigningKeySigner(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(kp.getPrivate()));
        certReqBuild.addControl(new JcaPKIArchiveControlBuilder(kp.getPrivate(), new X500Principal("CN=test")).addRecipientGenerator(new JceKeyTransRecipientInfoGenerator(cert).setProvider(BC)).build(new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(CMSEnvelopedDataGenerator.AES128_CBC)).setProvider(BC).build()));
        JcaCertificateRequestMessage certReqMsg = new JcaCertificateRequestMessage(certReqBuild.build().getEncoded());
        AllTests.assertTrue((boolean)certReqMsg.isValidSigningKeyPOP(new JcaContentVerifierProviderBuilder().setProvider(BC).build(kp.getPublic())));
        AllTests.assertEquals((Object)kp.getPublic(), (Object)certReqMsg.getPublicKey());
    }

    public void testEncryptedValue() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509Certificate cert = AllTests.makeV1Certificate(kp, "CN=Test", kp, "CN=Test");
        JcaEncryptedValueBuilder build = new JcaEncryptedValueBuilder(new JceAsymmetricKeyWrapper(cert.getPublicKey()).setProvider(BC), new JceCRMFEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider(BC).build());
        EncryptedValue value = build.build(cert);
        JceAsymmetricValueDecryptorGenerator decGen = new JceAsymmetricValueDecryptorGenerator(kp.getPrivate()).setProvider(BC);
        this.encryptedValueParserTest(value, decGen, cert);
        this.encryptedValueParserTest(EncryptedValue.getInstance(value.getEncoded()), decGen, cert);
    }

    private void encryptedValueParserTest(EncryptedValue value, ValueDecryptorGenerator decGen, X509Certificate cert) throws Exception {
        EncryptedValueParser parser = new EncryptedValueParser(value);
        X509CertificateHolder holder = parser.readCertificateHolder(decGen);
        AllTests.assertTrue((boolean)Arrays.areEqual(cert.getEncoded(), holder.getEncoded()));
    }

    public void testEncryptedValuePassphrase() throws Exception {
        char[] passphrase = PASSPHRASE.toCharArray();
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509Certificate cert = AllTests.makeV1Certificate(kp, "CN=Test", kp, "CN=Test");
        EncryptedValueBuilder build = new EncryptedValueBuilder(new JceAsymmetricKeyWrapper(cert.getPublicKey()).setProvider(BC), new JceCRMFEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider(BC).build());
        EncryptedValue value = build.build(passphrase);
        JceAsymmetricValueDecryptorGenerator decGen = new JceAsymmetricValueDecryptorGenerator(kp.getPrivate()).setProvider(BC);
        this.encryptedValuePassphraseParserTest(value, null, decGen, cert);
        this.encryptedValuePassphraseParserTest(EncryptedValue.getInstance(value.getEncoded()), null, decGen, cert);
    }

    public void testEncryptedValuePassphraseWithPadding() throws Exception {
        char[] passphrase = PASSPHRASE.toCharArray();
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509Certificate cert = AllTests.makeV1Certificate(kp, "CN=Test", kp, "CN=Test");
        BcFixedLengthMGF1Padder mgf1Padder = new BcFixedLengthMGF1Padder(200, new SecureRandom());
        EncryptedValueBuilder build = new EncryptedValueBuilder(new JceAsymmetricKeyWrapper(cert.getPublicKey()).setProvider(BC), new JceCRMFEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider(BC).build(), mgf1Padder);
        EncryptedValue value = build.build(passphrase);
        JceAsymmetricValueDecryptorGenerator decGen = new JceAsymmetricValueDecryptorGenerator(kp.getPrivate()).setProvider(BC);
        this.encryptedValuePassphraseParserTest(value, mgf1Padder, decGen, cert);
        this.encryptedValuePassphraseParserTest(EncryptedValue.getInstance(value.getEncoded()), mgf1Padder, decGen, cert);
    }

    private void encryptedValuePassphraseParserTest(EncryptedValue value, EncryptedValuePadder padder, ValueDecryptorGenerator decGen, X509Certificate cert) throws Exception {
        EncryptedValueParser parser = new EncryptedValueParser(value, padder);
        AllTests.assertTrue((boolean)Arrays.areEqual(PASSPHRASE.toCharArray(), parser.readPassphrase(decGen)));
    }

    private static X509Certificate makeV1Certificate(KeyPair subKP, String _subDN, KeyPair issKP, String _issDN) throws GeneralSecurityException, IOException, OperatorCreationException {
        PublicKey subPub = subKP.getPublic();
        PrivateKey issPriv = issKP.getPrivate();
        PublicKey issPub = issKP.getPublic();
        JcaX509v1CertificateBuilder v1CertGen = new JcaX509v1CertificateBuilder(new X500Name(_issDN), BigInteger.valueOf(System.currentTimeMillis()), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 8640000000L), new X500Name(_subDN), subPub);
        JcaContentSignerBuilder signerBuilder = null;
        signerBuilder = issPub instanceof RSAPublicKey ? new JcaContentSignerBuilder("SHA1WithRSA") : (issPub.getAlgorithm().equals("DSA") ? new JcaContentSignerBuilder("SHA1withDSA") : (issPub.getAlgorithm().equals("ECDSA") ? new JcaContentSignerBuilder("SHA1withECDSA") : (issPub.getAlgorithm().equals("ECGOST3410") ? new JcaContentSignerBuilder("GOST3411withECGOST3410") : new JcaContentSignerBuilder("GOST3411WithGOST3410"))));
        signerBuilder.setProvider(BC);
        X509Certificate _cert = new JcaX509CertificateConverter().setProvider(BC).getCertificate(v1CertGen.build(signerBuilder.build(issPriv)));
        _cert.checkValidity(new Date());
        _cert.verify(issPub);
        return _cert;
    }
}

