/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cert.crmf;

import java.io.IOException;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.EnvelopedData;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.EncKeyWithID;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.EncryptedKey;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.PKIArchiveOptions;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.GeneralName;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.PKIArchiveControl;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSEnvelopedData;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSException;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSProcessableByteArray;
import shaded.cfca.sadk.org.bouncycastle.cms.RecipientInfoGenerator;
import shaded.cfca.sadk.org.bouncycastle.operator.OutputEncryptor;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientGen) {
        this.envGen.addRecipientInfoGenerator(recipientGen);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor contentEncryptor) throws CMSException {
        CMSEnvelopedData envContent = this.envGen.generate(this.keyContent, contentEncryptor);
        EnvelopedData envD = EnvelopedData.getInstance(envContent.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envD)));
    }
}

