/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cert.crmf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERBitString;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.EncryptedValue;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.CRMFException;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.EncryptedValuePadder;
import shaded.cfca.sadk.org.bouncycastle.operator.KeyWrapper;
import shaded.cfca.sadk.org.bouncycastle.operator.OperatorException;
import shaded.cfca.sadk.org.bouncycastle.operator.OutputEncryptor;
import shaded.cfca.sadk.org.bouncycastle.util.Strings;

public class EncryptedValueBuilder {
    private KeyWrapper wrapper;
    private OutputEncryptor encryptor;
    private EncryptedValuePadder padder;

    public EncryptedValueBuilder(KeyWrapper wrapper, OutputEncryptor encryptor) {
        this(wrapper, encryptor, null);
    }

    public EncryptedValueBuilder(KeyWrapper wrapper, OutputEncryptor encryptor, EncryptedValuePadder padder) {
        this.wrapper = wrapper;
        this.encryptor = encryptor;
        this.padder = padder;
    }

    public EncryptedValue build(char[] revocationPassphrase) throws CRMFException {
        return this.encryptData(this.padData(Strings.toUTF8ByteArray(revocationPassphrase)));
    }

    public EncryptedValue build(X509CertificateHolder holder) throws CRMFException {
        try {
            return this.encryptData(this.padData(holder.getEncoded()));
        }
        catch (IOException e) {
            throw new CRMFException("cannot encode certificate: " + e.getMessage(), e);
        }
    }

    private EncryptedValue encryptData(byte[] data) throws CRMFException {
        DERBitString encSymmKey;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        OutputStream eOut = this.encryptor.getOutputStream(bOut);
        try {
            eOut.write(data);
            eOut.close();
        }
        catch (IOException e) {
            throw new CRMFException("cannot process data: " + e.getMessage(), e);
        }
        AlgorithmIdentifier intendedAlg = null;
        AlgorithmIdentifier symmAlg = this.encryptor.getAlgorithmIdentifier();
        try {
            this.wrapper.generateWrappedKey(this.encryptor.getKey());
            encSymmKey = new DERBitString(this.wrapper.generateWrappedKey(this.encryptor.getKey()));
        }
        catch (OperatorException e) {
            throw new CRMFException("cannot wrap key: " + e.getMessage(), e);
        }
        AlgorithmIdentifier keyAlg = this.wrapper.getAlgorithmIdentifier();
        ASN1OctetString valueHint = null;
        DERBitString encValue = new DERBitString(bOut.toByteArray());
        return new EncryptedValue(intendedAlg, symmAlg, encSymmKey, keyAlg, valueHint, encValue);
    }

    private byte[] padData(byte[] data) {
        if (this.padder != null) {
            return this.padder.getPaddedData(data);
        }
        return data;
    }
}

