/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cert.crmf;

import java.io.IOException;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERUTF8String;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.CertReqMsg;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.CertTemplate;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.Controls;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.PKIArchiveOptions;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.PKMACValue;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.POPOSigningKey;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.ProofOfPossession;
import shaded.cfca.sadk.org.bouncycastle.cert.CertIOException;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.AuthenticatorControl;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.CRMFException;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.CRMFUtil;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.Control;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.PKIArchiveControl;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.PKMACBuilder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.PKMACValueVerifier;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.RegTokenControl;
import shaded.cfca.sadk.org.bouncycastle.operator.ContentVerifier;
import shaded.cfca.sadk.org.bouncycastle.operator.ContentVerifierProvider;
import shaded.cfca.sadk.org.bouncycastle.operator.OperatorCreationException;

public class CertificateRequestMessage {
    public static final int popRaVerified = 0;
    public static final int popSigningKey = 1;
    public static final int popKeyEncipherment = 2;
    public static final int popKeyAgreement = 3;
    private final CertReqMsg certReqMsg;
    private final Controls controls;

    private static CertReqMsg parseBytes(byte[] encoding) throws IOException {
        try {
            return CertReqMsg.getInstance(ASN1Primitive.fromByteArray(encoding));
        }
        catch (ClassCastException e) {
            throw new CertIOException("malformed data: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new CertIOException("malformed data: " + e.getMessage(), e);
        }
    }

    public CertificateRequestMessage(byte[] certReqMsg) throws IOException {
        this(CertificateRequestMessage.parseBytes(certReqMsg));
    }

    public CertificateRequestMessage(CertReqMsg certReqMsg) {
        this.certReqMsg = certReqMsg;
        this.controls = certReqMsg.getCertReq().getControls();
    }

    public CertReqMsg toASN1Structure() {
        return this.certReqMsg;
    }

    public CertTemplate getCertTemplate() {
        return this.certReqMsg.getCertReq().getCertTemplate();
    }

    public boolean hasControls() {
        return this.controls != null;
    }

    public boolean hasControl(ASN1ObjectIdentifier type) {
        return this.findControl(type) != null;
    }

    public Control getControl(ASN1ObjectIdentifier type) {
        AttributeTypeAndValue found = this.findControl(type);
        if (found != null) {
            if (found.getType().equals(CRMFObjectIdentifiers.id_regCtrl_pkiArchiveOptions)) {
                return new PKIArchiveControl(PKIArchiveOptions.getInstance(found.getValue()));
            }
            if (found.getType().equals(CRMFObjectIdentifiers.id_regCtrl_regToken)) {
                return new RegTokenControl(DERUTF8String.getInstance(found.getValue()));
            }
            if (found.getType().equals(CRMFObjectIdentifiers.id_regCtrl_authenticator)) {
                return new AuthenticatorControl(DERUTF8String.getInstance(found.getValue()));
            }
        }
        return null;
    }

    private AttributeTypeAndValue findControl(ASN1ObjectIdentifier type) {
        if (this.controls == null) {
            return null;
        }
        AttributeTypeAndValue[] tAndVs = this.controls.toAttributeTypeAndValueArray();
        AttributeTypeAndValue found = null;
        for (int i = 0; i != tAndVs.length; ++i) {
            if (!tAndVs[i].getType().equals(type)) continue;
            found = tAndVs[i];
            break;
        }
        return found;
    }

    public boolean hasProofOfPossession() {
        return this.certReqMsg.getPopo() != null;
    }

    public int getProofOfPossessionType() {
        return this.certReqMsg.getPopo().getType();
    }

    public boolean hasSigningKeyProofOfPossessionWithPKMAC() {
        ProofOfPossession pop = this.certReqMsg.getPopo();
        if (pop.getType() == 1) {
            POPOSigningKey popoSign = POPOSigningKey.getInstance(pop.getObject());
            return popoSign.getPoposkInput().getPublicKeyMAC() != null;
        }
        return false;
    }

    public boolean isValidSigningKeyPOP(ContentVerifierProvider verifierProvider) throws CRMFException, IllegalStateException {
        ProofOfPossession pop = this.certReqMsg.getPopo();
        if (pop.getType() == 1) {
            POPOSigningKey popoSign = POPOSigningKey.getInstance(pop.getObject());
            if (popoSign.getPoposkInput() != null && popoSign.getPoposkInput().getPublicKeyMAC() != null) {
                throw new IllegalStateException("verification requires password check");
            }
            return this.verifySignature(verifierProvider, popoSign);
        }
        throw new IllegalStateException("not Signing Key type of proof of possession");
    }

    public boolean isValidSigningKeyPOP(ContentVerifierProvider verifierProvider, PKMACBuilder macBuilder, char[] password) throws CRMFException, IllegalStateException {
        ProofOfPossession pop = this.certReqMsg.getPopo();
        if (pop.getType() == 1) {
            POPOSigningKey popoSign = POPOSigningKey.getInstance(pop.getObject());
            if (popoSign.getPoposkInput() == null || popoSign.getPoposkInput().getSender() != null) {
                throw new IllegalStateException("no PKMAC present in proof of possession");
            }
            PKMACValueVerifier macVerifier = new PKMACValueVerifier(macBuilder);
            PKMACValue pkMAC = popoSign.getPoposkInput().getPublicKeyMAC();
            if (macVerifier.isValid(pkMAC, password, this.getCertTemplate().getPublicKey())) {
                return this.verifySignature(verifierProvider, popoSign);
            }
            return false;
        }
        throw new IllegalStateException("not Signing Key type of proof of possession");
    }

    private boolean verifySignature(ContentVerifierProvider verifierProvider, POPOSigningKey popoSign) throws CRMFException {
        ContentVerifier verifier;
        try {
            verifier = verifierProvider.get(popoSign.getAlgorithmIdentifier());
        }
        catch (OperatorCreationException e) {
            throw new CRMFException("unable to create verifier: " + e.getMessage(), e);
        }
        if (popoSign.getPoposkInput() != null) {
            CRMFUtil.derEncodeToStream(popoSign.getPoposkInput(), verifier.getOutputStream());
        } else {
            CRMFUtil.derEncodeToStream(this.certReqMsg.getCertReq(), verifier.getOutputStream());
        }
        return verifier.verify(popoSign.getSignature().getBytes());
    }

    public byte[] getEncoded() throws IOException {
        return this.certReqMsg.getEncoded();
    }
}

