/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.asn1.test;

import java.io.IOException;
import java.math.BigInteger;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1GeneralizedTime;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import shaded.cfca.sadk.org.bouncycastle.asn1.test.ASN1UnitTest;
import shaded.cfca.sadk.org.bouncycastle.asn1.x500.DirectoryString;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.sigi.NameOrPseudonym;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.sigi.PersonalData;

public class PersonalDataUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "PersonalData";
    }

    public void performTest() throws Exception {
        NameOrPseudonym nameOrPseudonym = new NameOrPseudonym("pseudonym");
        BigInteger nameDistinguisher = BigInteger.valueOf(10L);
        ASN1GeneralizedTime dateOfBirth = new ASN1GeneralizedTime("20070315173729Z");
        DirectoryString placeOfBirth = new DirectoryString("placeOfBirth");
        String gender = "M";
        DirectoryString postalAddress = new DirectoryString("address");
        PersonalData data = new PersonalData(nameOrPseudonym, nameDistinguisher, dateOfBirth, placeOfBirth, gender, postalAddress);
        this.checkConstruction(data, nameOrPseudonym, nameDistinguisher, dateOfBirth, placeOfBirth, gender, postalAddress);
        data = new PersonalData(nameOrPseudonym, null, dateOfBirth, placeOfBirth, gender, postalAddress);
        this.checkConstruction(data, nameOrPseudonym, null, dateOfBirth, placeOfBirth, gender, postalAddress);
        data = new PersonalData(nameOrPseudonym, nameDistinguisher, null, placeOfBirth, gender, postalAddress);
        this.checkConstruction(data, nameOrPseudonym, nameDistinguisher, null, placeOfBirth, gender, postalAddress);
        data = new PersonalData(nameOrPseudonym, nameDistinguisher, dateOfBirth, null, gender, postalAddress);
        this.checkConstruction(data, nameOrPseudonym, nameDistinguisher, dateOfBirth, null, gender, postalAddress);
        data = new PersonalData(nameOrPseudonym, nameDistinguisher, dateOfBirth, placeOfBirth, null, postalAddress);
        this.checkConstruction(data, nameOrPseudonym, nameDistinguisher, dateOfBirth, placeOfBirth, null, postalAddress);
        data = new PersonalData(nameOrPseudonym, nameDistinguisher, dateOfBirth, placeOfBirth, gender, null);
        this.checkConstruction(data, nameOrPseudonym, nameDistinguisher, dateOfBirth, placeOfBirth, gender, null);
        data = PersonalData.getInstance(null);
        if (data != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            PersonalData.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void checkConstruction(PersonalData data, NameOrPseudonym nameOrPseudonym, BigInteger nameDistinguisher, ASN1GeneralizedTime dateOfBirth, DirectoryString placeOfBirth, String gender, DirectoryString postalAddress) throws IOException {
        this.checkValues(data, nameOrPseudonym, nameDistinguisher, dateOfBirth, placeOfBirth, gender, postalAddress);
        data = PersonalData.getInstance(data);
        this.checkValues(data, nameOrPseudonym, nameDistinguisher, dateOfBirth, placeOfBirth, gender, postalAddress);
        ASN1InputStream aIn = new ASN1InputStream(data.toASN1Object().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        data = PersonalData.getInstance(seq);
        this.checkValues(data, nameOrPseudonym, nameDistinguisher, dateOfBirth, placeOfBirth, gender, postalAddress);
    }

    private void checkValues(PersonalData data, NameOrPseudonym nameOrPseudonym, BigInteger nameDistinguisher, ASN1GeneralizedTime dateOfBirth, DirectoryString placeOfBirth, String gender, DirectoryString postalAddress) {
        this.checkMandatoryField("nameOrPseudonym", nameOrPseudonym, data.getNameOrPseudonym());
        this.checkOptionalField("nameDistinguisher", nameDistinguisher, data.getNameDistinguisher());
        this.checkOptionalField("dateOfBirth", dateOfBirth, data.getDateOfBirth());
        this.checkOptionalField("placeOfBirth", placeOfBirth, data.getPlaceOfBirth());
        this.checkOptionalField("gender", gender, data.getGender());
        this.checkOptionalField("postalAddress", postalAddress, data.getPostalAddress());
    }

    public static void main(String[] args) {
        PersonalDataUnitTest.runTest(new PersonalDataUnitTest());
    }
}

