/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1OutputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.DEROutputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Hex;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class OIDTest
extends SimpleTest {
    byte[] req1 = Hex.decode("0603813403");
    byte[] req2 = Hex.decode("06082A36FFFFFFDD6311");

    public String getName() {
        return "OID";
    }

    private void recodeCheck(String oid, byte[] enc) throws IOException {
        ASN1ObjectIdentifier o = new ASN1ObjectIdentifier(oid);
        ByteArrayInputStream bIn = new ByteArrayInputStream(enc);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        ASN1ObjectIdentifier encO = (ASN1ObjectIdentifier)aIn.readObject();
        if (!o.equals(encO)) {
            this.fail("oid ID didn't match", o, encO);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        dOut.writeObject(o);
        byte[] bytes = bOut.toByteArray();
        if (bytes.length != enc.length) {
            this.fail("failed length test");
        }
        for (int i = 0; i != enc.length; ++i) {
            if (bytes[i] == enc[i]) continue;
            this.fail("failed comparison test", new String(Hex.encode(enc)), new String(Hex.encode(bytes)));
        }
    }

    private void validOidCheck(String oid) throws IOException {
        ASN1ObjectIdentifier o = new ASN1ObjectIdentifier(oid);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(o);
        ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        o = (ASN1ObjectIdentifier)aIn.readObject();
        if (!o.getId().equals(oid)) {
            this.fail("failed oid check for " + oid);
        }
    }

    private void invalidOidCheck(String oid) {
        try {
            new ASN1ObjectIdentifier(oid);
            this.fail("failed to catch bad oid: " + oid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void branchCheck(String stem, String branch) {
        String actual;
        String expected = stem + "." + branch;
        if (!expected.equals(actual = new ASN1ObjectIdentifier(stem).branch(branch).getId())) {
            this.fail("failed 'branch' check for " + stem + "/" + branch);
        }
    }

    private void onCheck(String stem, String test, boolean expected) {
        if (expected != new ASN1ObjectIdentifier(test).on(new ASN1ObjectIdentifier(stem))) {
            this.fail("failed 'on' check for " + stem + "/" + test);
        }
    }

    public void performTest() throws IOException {
        this.recodeCheck("2.100.3", this.req1);
        this.recodeCheck("1.2.54.34359733987.17", this.req2);
        this.validOidCheck(PKCSObjectIdentifiers.pkcs_9_at_contentType.getId());
        this.validOidCheck("0.1");
        this.validOidCheck("1.1.127.32512.8323072.2130706432.545460846592.139637976727552.35747322042253312.9151314442816847872");
        this.validOidCheck("1.2.123.12345678901.1.1.1");
        this.validOidCheck("2.25.196556539987194312349856245628873852187.1");
        this.invalidOidCheck("0");
        this.invalidOidCheck("1");
        this.invalidOidCheck("2");
        this.invalidOidCheck("3.1");
        this.invalidOidCheck("..1");
        this.invalidOidCheck("192.168.1.1");
        this.invalidOidCheck(".123452");
        this.invalidOidCheck("1.");
        this.invalidOidCheck("1.345.23.34..234");
        this.invalidOidCheck("1.345.23.34.234.");
        this.invalidOidCheck(".12.345.77.234");
        this.invalidOidCheck(".12.345.77.234.");
        this.invalidOidCheck("1.2.3.4.A.5");
        this.invalidOidCheck("1,2");
        this.branchCheck("1.1", "2.2");
        this.onCheck("1.1", "1.1", false);
        this.onCheck("1.1", "1.2", false);
        this.onCheck("1.1", "1.2.1", false);
        this.onCheck("1.1", "2.1", false);
        this.onCheck("1.1", "1.11", false);
        this.onCheck("1.12", "1.1.2", false);
        this.onCheck("1.1", "1.1.1", true);
        this.onCheck("1.1", "1.1.2", true);
    }

    public static void main(String[] args) {
        OIDTest.runTest(new OIDTest());
    }
}

