/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.asn1.test;

import java.io.IOException;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class InputStreamTest
extends SimpleTest {
    private static final byte[] outOfBoundsLength = new byte[]{48, -1, -1, -1, -1, -1};
    private static final byte[] negativeLength = new byte[]{48, -124, -1, -1, -1, -1};
    private static final byte[] outsideLimitLength = new byte[]{48, -125, 15, -1, -1};

    public String getName() {
        return "InputStream";
    }

    public void performTest() throws Exception {
        block8: {
            ASN1InputStream aIn;
            block7: {
                block6: {
                    aIn = new ASN1InputStream(outOfBoundsLength);
                    try {
                        aIn.readObject();
                        this.fail("out of bounds length not detected.");
                    }
                    catch (IOException e) {
                        if (e.getMessage().startsWith("DER length more than 4 bytes")) break block6;
                        this.fail("wrong exception: " + e.getMessage());
                    }
                }
                aIn = new ASN1InputStream(negativeLength);
                try {
                    aIn.readObject();
                    this.fail("negative length not detected.");
                }
                catch (IOException e) {
                    if (e.getMessage().equals("corrupted stream - negative length found")) break block7;
                    this.fail("wrong exception: " + e.getMessage());
                }
            }
            aIn = new ASN1InputStream(outsideLimitLength);
            try {
                aIn.readObject();
                this.fail("outside limit length not detected.");
            }
            catch (IOException e) {
                if (e.getMessage().equals("corrupted stream - out of bounds length found")) break block8;
                this.fail("wrong exception: " + e.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        InputStreamTest.runTest(new InputStreamTest());
    }
}

