/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.asn1.test;

import java.io.IOException;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERUTF8String;
import shaded.cfca.sadk.org.bouncycastle.asn1.ess.ContentHints;
import shaded.cfca.sadk.org.bouncycastle.asn1.test.ASN1UnitTest;

public class ContentHintsUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "ContentHints";
    }

    public void performTest() throws Exception {
        DERUTF8String contentDescription = new DERUTF8String("Description");
        ASN1ObjectIdentifier contentType = new ASN1ObjectIdentifier("1.2.2.3");
        ContentHints hints = new ContentHints(contentType);
        this.checkConstruction(hints, contentType, null);
        hints = new ContentHints(contentType, contentDescription);
        this.checkConstruction(hints, contentType, contentDescription);
        hints = ContentHints.getInstance(null);
        if (hints != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            ContentHints.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void checkConstruction(ContentHints hints, ASN1ObjectIdentifier contentType, DERUTF8String description) throws IOException {
        this.checkValues(hints, contentType, description);
        hints = ContentHints.getInstance(hints);
        this.checkValues(hints, contentType, description);
        ASN1InputStream aIn = new ASN1InputStream(hints.toASN1Primitive().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        hints = ContentHints.getInstance(seq);
        this.checkValues(hints, contentType, description);
    }

    private void checkValues(ContentHints hints, ASN1ObjectIdentifier contentType, DERUTF8String description) {
        this.checkMandatoryField("contentType", contentType, hints.getContentType());
        this.checkOptionalField("description", description, hints.getContentDescription());
    }

    public static void main(String[] args) {
        ContentHintsUnitTest.runTest(new ContentHintsUnitTest());
    }
}

