/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.asn1.test;

import java.io.IOException;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import shaded.cfca.sadk.org.bouncycastle.asn1.isismtt.x509.Admissions;
import shaded.cfca.sadk.org.bouncycastle.asn1.isismtt.x509.NamingAuthority;
import shaded.cfca.sadk.org.bouncycastle.asn1.isismtt.x509.ProfessionInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.test.ASN1UnitTest;
import shaded.cfca.sadk.org.bouncycastle.asn1.x500.DirectoryString;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.GeneralName;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.X509Name;

public class AdmissionsUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "Admissions";
    }

    public void performTest() throws Exception {
        GeneralName name = new GeneralName(new X509Name("CN=hello world"));
        NamingAuthority auth = new NamingAuthority(new ASN1ObjectIdentifier("1.2.3"), "url", new DirectoryString("fred"));
        Admissions admissions = new Admissions(name, auth, new ProfessionInfo[0]);
        this.checkConstruction(admissions, name, auth);
        admissions = Admissions.getInstance(null);
        if (admissions != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            Admissions.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void checkConstruction(Admissions admissions, GeneralName name, NamingAuthority auth) throws IOException {
        this.checkValues(admissions, name, auth);
        admissions = Admissions.getInstance(admissions);
        this.checkValues(admissions, name, auth);
        ASN1InputStream aIn = new ASN1InputStream(admissions.toASN1Object().getEncoded());
        ASN1Sequence info = (ASN1Sequence)aIn.readObject();
        admissions = Admissions.getInstance(info);
        this.checkValues(admissions, name, auth);
    }

    private void checkValues(Admissions admissions, GeneralName name, NamingAuthority auth) {
        this.checkMandatoryField("admissionAuthority", name, admissions.getAdmissionAuthority());
        this.checkMandatoryField("namingAuthority", auth, admissions.getNamingAuthority());
    }

    public static void main(String[] args) {
        AdmissionsUnitTest.runTest(new AdmissionsUnitTest());
    }
}

