/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.asn1.test;

import java.io.IOException;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1String;
import shaded.cfca.sadk.org.bouncycastle.asn1.isismtt.x509.AdditionalInformationSyntax;
import shaded.cfca.sadk.org.bouncycastle.asn1.test.ASN1UnitTest;
import shaded.cfca.sadk.org.bouncycastle.asn1.x500.DirectoryString;

public class AdditionalInformationSyntaxUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "AdditionalInformationSyntax";
    }

    public void performTest() throws Exception {
        AdditionalInformationSyntax syntax = new AdditionalInformationSyntax("hello world");
        this.checkConstruction(syntax, new DirectoryString("hello world"));
        try {
            AdditionalInformationSyntax.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(AdditionalInformationSyntax syntax, DirectoryString information) throws IOException {
        this.checkValues(syntax, information);
        syntax = AdditionalInformationSyntax.getInstance(syntax);
        this.checkValues(syntax, information);
        ASN1InputStream aIn = new ASN1InputStream(syntax.toASN1Object().getEncoded());
        ASN1String info = (ASN1String)((Object)aIn.readObject());
        syntax = AdditionalInformationSyntax.getInstance(info);
        this.checkValues(syntax, information);
    }

    private void checkValues(AdditionalInformationSyntax syntax, DirectoryString information) {
        this.checkMandatoryField("information", information, syntax.getInformation());
    }

    public static void main(String[] args) {
        AdditionalInformationSyntaxUnitTest.runTest(new AdditionalInformationSyntaxUnitTest());
    }
}

