/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.asn1.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import shaded.cfca.sadk.algorithm.common.PKIException;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import shaded.cfca.sadk.org.bouncycastle.asn1.DEROutputStream;

public class ASN1Parser {
    public static byte[] parseDERObj2Bytes(ASN1Encodable obj) throws PKIException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(bos);
        try {
            dos.writeObject(obj);
            return bos.toByteArray();
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.DEROBJ_BYTES, PKIException.DEROBJ_BYTES_DES, ex);
        }
    }

    public static ASN1Object parseBytes2DERObj(byte[] data) throws PKIException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ASN1InputStream ais = new ASN1InputStream(bis);
        ASN1Primitive derObj = null;
        try {
            ASN1Primitive aSN1Primitive = derObj = ais.readObject();
            return aSN1Primitive;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.BYTES_DEROBJ, PKIException.BYTES_DEROBJ_DES, ex);
        }
        finally {
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public static ASN1Sequence parseOCT2SEQ(ASN1OctetString asn1oct) throws PKIException {
        byte[] data = asn1oct.getOctets();
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ASN1InputStream ais = new ASN1InputStream(bis);
        ASN1Sequence seqObj = null;
        try {
            seqObj = (ASN1Sequence)ais.readObject();
            ais.close();
            return seqObj;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.OCTECT_DER_ERR, PKIException.OCTECT_DER_ERR_DES, ex);
        }
    }

    public static boolean isBase64Compatability(byte[] data) {
        boolean isBase64Compatibility = true;
        for (int i = 0; i < data.length; ++i) {
            byte tmp = data[i];
            if (65 <= tmp && tmp <= 90 || 97 <= tmp && tmp <= 122 || 48 <= tmp && tmp <= 57 || tmp == 43 || tmp == 47 || tmp == 61 || tmp == 13 || tmp == 10 || tmp == 32 || tmp == 9) continue;
            isBase64Compatibility = false;
            break;
        }
        return isBase64Compatibility;
    }

    public static byte[] deleteCRLF(byte[] data) {
        byte tmp;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((tmp = (byte)bis.read()) != -1) {
            if (tmp == 10 || tmp == 13) continue;
            bos.write(tmp);
        }
        return bos.toByteArray();
    }
}

