/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.asn1.parser;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import shaded.cfca.sadk.algorithm.common.PKIException;
import shaded.cfca.sadk.asn1.parser.ASN1Node;

public class ASN1BigFileParser {
    private File f;
    private RandomAccessFile fs = null;

    public ASN1BigFileParser(File f) {
        this.f = f;
    }

    public ASN1Node parser() throws Exception {
        try {
            this.fs = new RandomAccessFile(this.f, "r");
            ASN1Node parentNode = this.parseASN1TLV(0L);
            this.Node_Parser(parentNode, 0);
            if (this.fs != null) {
                this.fs.close();
            }
            return parentNode;
        }
        catch (Exception e) {
            throw new PKIException("the file's format is wrong,please check it if it is der,can not parse the data after Base64!");
        }
    }

    private ASN1Node parseASN1TLV(long startPos) throws Exception {
        ASN1Node node = new ASN1Node();
        node.f = this.f;
        this.fs.seek(startPos);
        int tag = this.fs.read();
        if (tag == 0) {
            return null;
        }
        if (tag == -1) {
            throw new Exception("the file's format is wrong!");
        }
        this.getASN1ValueLength(this.f, startPos + 1L, node);
        node.tag = tag;
        return node;
    }

    private void Node_Parser(ASN1Node parentNode, int recursiveCount) throws Exception {
        ASN1Node childNode;
        if (parentNode == null) {
            return;
        }
        if (recursiveCount >= 50) {
            throw new Exception("the file is not good asn.1 format,Please check it!");
        }
        ++recursiveCount;
        int tagValue = parentNode.tag;
        if (tagValue >= 0 && tagValue <= 31 || tagValue >= 128 && tagValue <= 143) {
            if (parentNode.isInfiniteLength) {
                this.getInfiniteLength(parentNode);
            }
            return;
        }
        long valueStartPos = parentNode.valueStartPos;
        long childNodeLength = 0L;
        while (childNodeLength < parentNode.valueLength && valueStartPos < this.f.length() && (childNode = this.parseASN1TLV(valueStartPos)) != null) {
            this.Node_Parser(childNode, recursiveCount);
            if (childNode.isInfiniteLength) {
                this.getInfiniteLength(childNode);
            }
            childNode.parentNode = parentNode;
            parentNode.childNodes.add(childNode);
            valueStartPos = parentNode.valueStartPos + (childNodeLength += childNode.totalLength);
        }
        if (parentNode.isInfiniteLength) {
            this.getInfiniteLength(parentNode);
        }
    }

    private void getInfiniteLength(ASN1Node node) throws Exception {
        block7: {
            if (!node.isInfiniteLength) {
                return;
            }
            if (node.childNodes.size() == 0) {
                int previousByte = -1;
                int currentByte = -1;
                long valueLength = 0L;
                long valueStartPos = node.valueStartPos;
                this.fs.seek(valueStartPos);
                while ((currentByte = this.fs.read()) != -1) {
                    ++valueLength;
                    if (previousByte == 0 && currentByte == 0) {
                        node.isInfiniteLength = false;
                        node.valueLength = valueLength;
                        node.totalLength = 2L + valueLength;
                        break block7;
                    }
                    previousByte = currentByte;
                }
                break block7;
            }
            node.valueLength = 0L;
            for (int i = 0; i < node.childNodes.size(); ++i) {
                ASN1Node child = (ASN1Node)node.childNodes.get(i);
                this.getInfiniteLength(child);
                node.valueLength += child.totalLength;
            }
            node.isInfiniteLength = false;
            node.totalLength = 2L + node.valueLength + 2L;
        }
    }

    private void getASN1ValueLength(File f, long lengthStartPos, ASN1Node node) throws Exception {
        this.fs.seek(lengthStartPos);
        long length = this.fs.read();
        if (length < 0L) {
            throw new EOFException("EOF found when length expected");
        }
        if (length == 128L) {
            node.isInfiniteLength = true;
            node.berNode = true;
            node.valueLengthSize = 1;
            node.valueLength = Long.MAX_VALUE;
            node.valueStartPos = 1L + lengthStartPos;
            node.totalLength = Long.MAX_VALUE;
            return;
        }
        long size = 1L;
        if (length > 127L) {
            size = length & 0x7FL;
            length = 0L;
            int i = 0;
            while ((long)i < size) {
                int next = this.fs.read();
                if (next < 0) {
                    throw new EOFException("EOF found reading length");
                }
                length = (length << 8) + (long)next;
                ++i;
            }
            if (length < 0L) {
                throw new IOException("corrupted stream - negative length found");
            }
            node.isInfiniteLength = false;
            node.berNode = false;
            node.valueLengthSize = (int)size;
            node.valueLength = length;
            node.valueStartPos = lengthStartPos + size + 1L;
            node.totalLength = 2L + size + length;
        } else {
            node.isInfiniteLength = false;
            node.berNode = false;
            node.valueLengthSize = (int)size;
            node.valueLength = length;
            node.valueStartPos = lengthStartPos + size;
            node.totalLength = 1L + size + length;
        }
    }
}

