/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.algorithm.util;

import java.math.BigInteger;

public class BigIntegerUtil {
    public static BigInteger toPositiveInteger(byte[] in) {
        if (in == null) {
            return null;
        }
        byte[] bt = null;
        if (in[0] < 0) {
            bt = new byte[in.length + 1];
            bt[0] = 0;
            System.arraycopy(in, 0, bt, 1, bt.length - 1);
        } else {
            bt = in;
        }
        return new BigInteger(bt);
    }

    public static byte[] asUnsigned32ByteArray(BigInteger n) {
        return BigIntegerUtil.asUnsignedNByteArray(n, 32);
    }

    public static byte[] asUnsignedNByteArray(BigInteger x, int length) {
        if (x == null) {
            return null;
        }
        byte[] tmp = new byte[length];
        byte[] arrays = x.toByteArray();
        int len = arrays.length;
        if (len > length + 1) {
            return null;
        }
        if (len == length + 1) {
            if (arrays[0] != 0) {
                return null;
            }
            System.arraycopy(arrays, 1, tmp, 0, length);
            return tmp;
        }
        System.arraycopy(arrays, 0, tmp, length - len, len);
        return tmp;
    }
}

