/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.algorithm.sm2;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import shaded.cfca.sadk.algorithm.sm2.SM2Param;
import shaded.cfca.sadk.algorithm.util.BigIntegerUtil;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.math.ec.ECFieldElement;
import shaded.cfca.sadk.org.bouncycastle.math.ec.ECPoint;

public class SM2PublicKey
implements PublicKey {
    private static final long serialVersionUID = 1L;
    private transient ECPublicKeyParameters ecParam;
    private byte[] SM2PubKeyData = null;
    private byte[] bPubX = null;
    private byte[] bPubY = null;
    private BigInteger iPubX = null;
    private BigInteger iPubY = null;
    private static final int SM2_PUBKEY_LENGTH = 32;
    private boolean withCompression = false;

    public String toString() {
        String sm2PublicKeyMark = "SM2 Public Key";
        String X = this.iPubX.toString();
        String Y = this.iPubY.toString();
        String lineSeparator = System.getProperty("line.separator");
        String sm2PubMsg = sm2PublicKeyMark + ":" + lineSeparator + "X:" + X + lineSeparator + "Y:" + Y;
        return sm2PubMsg;
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public String getFormat() {
        return "X.509";
    }

    public SM2PublicKey(byte[] SM2PubKeyData) {
        this.SM2PubKeyData = SM2PubKeyData;
        this.bPubX = new byte[32];
        System.arraycopy(this.SM2PubKeyData, 1, this.bPubX, 0, 32);
        this.bPubY = new byte[32];
        System.arraycopy(this.SM2PubKeyData, 33, this.bPubY, 0, 32);
        this.iPubX = new BigInteger(1, this.bPubX);
        this.iPubY = new BigInteger(1, this.bPubY);
        ECFieldElement.Fp ecc_px_fieldelement = new ECFieldElement.Fp(SM2Param.ecc_p, this.iPubX);
        ECFieldElement.Fp ecc_py_fieldelement = new ECFieldElement.Fp(SM2Param.ecc_p, this.iPubY);
        ECPoint.Fp pubPoint = new ECPoint.Fp(SM2Param.ecc_curve, ecc_px_fieldelement, ecc_py_fieldelement);
        this.ecParam = new ECPublicKeyParameters(pubPoint, SM2Param.ecc_bc_spec);
    }

    public SM2PublicKey(byte[] bPubX, byte[] bPubY) {
        BigInteger ecc_px = new BigInteger(1, bPubX);
        BigInteger ecc_py = new BigInteger(1, bPubY);
        ECFieldElement.Fp ecc_px_fieldelement = new ECFieldElement.Fp(SM2Param.ecc_p, ecc_px);
        ECFieldElement.Fp ecc_py_fieldelement = new ECFieldElement.Fp(SM2Param.ecc_p, ecc_py);
        ECPoint.Fp pubPoint = new ECPoint.Fp(SM2Param.ecc_curve, ecc_px_fieldelement, ecc_py_fieldelement);
        ECPublicKeyParameters ecParam = new ECPublicKeyParameters(pubPoint, SM2Param.ecc_bc_spec);
        this.constructSM2PublicKey(ecParam);
    }

    public SM2PublicKey(ECPublicKeyParameters ecParam) {
        this.constructSM2PublicKey(ecParam);
    }

    private void constructSM2PublicKey(ECPublicKeyParameters ecParam) {
        this.ecParam = ecParam;
        ECPoint Q = this.ecParam.getQ();
        ECFieldElement X = Q.getX();
        ECFieldElement Y = Q.getY();
        this.iPubX = X.toBigInteger();
        this.iPubY = Y.toBigInteger();
        this.bPubX = BigIntegerUtil.asUnsigned32ByteArray(this.iPubX);
        this.bPubY = BigIntegerUtil.asUnsigned32ByteArray(this.iPubY);
        this.SM2PubKeyData = new byte[65];
        this.SM2PubKeyData[0] = 4;
        System.arraycopy(this.bPubX, 0, this.SM2PubKeyData, 33 - this.bPubX.length, this.bPubX.length);
        System.arraycopy(this.bPubY, 0, this.SM2PubKeyData, 65 - this.bPubY.length, this.bPubY.length);
    }

    public byte[] getEncoded() {
        DERObjectIdentifier oid = new DERObjectIdentifier("1.2.156.10197.1.301");
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, oid), this.SM2PubKeyData);
        try {
            return info.getEncoded("DER");
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public ECPoint getQ() {
        return this.ecParam.getQ();
    }

    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    public byte[] getPubXByBytes() {
        return this.bPubX;
    }

    public void setPubXByBytes(byte[] bPubX) {
        this.bPubX = bPubX;
    }

    public byte[] getPubYByBytes() {
        return this.bPubY;
    }

    public void setPubYByBytes(byte[] bPubY) {
        this.bPubY = bPubY;
    }

    public void setPubXByInt(BigInteger iPubX) {
        this.iPubX = iPubX;
    }

    public BigInteger getPubXByInt() {
        return this.iPubX;
    }

    public void setPubYByInt(BigInteger iPubY) {
        this.iPubY = iPubY;
    }

    public BigInteger getPubYByInt() {
        return this.iPubY;
    }

    public boolean isWithCompression() {
        return this.withCompression;
    }
}

