/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.algorithm.sm2;

import java.math.BigInteger;
import shaded.cfca.sadk.algorithm.sm2.SM2Param;
import shaded.cfca.sadk.algorithm.sm2.SM3Digest;
import shaded.cfca.sadk.algorithm.util.BigEndianUtil;
import shaded.cfca.sadk.algorithm.util.BigIntegerUtil;

public class SM2HashZValue {
    public static byte[] getZa(BigInteger x, BigInteger y, byte[] userId) {
        return SM2HashZValue.addId(x, y, userId);
    }

    public static byte[] getSM2Za(byte[] x, byte[] y, byte[] id) {
        if (id == null || id.length == 0) {
            byte[] idTemp = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
            id = new byte[idTemp.length];
            System.arraycopy(idTemp, 0, id, 0, idTemp.length);
        }
        byte[] tmp = BigEndianUtil.IntToByte(id.length * 8);
        byte[] buffer = new byte[194 + id.length];
        buffer[0] = tmp[1];
        buffer[1] = tmp[0];
        byte[] a = SM2Param.getA();
        byte[] b = SM2Param.getB();
        byte[] gx = SM2Param.getGx();
        byte[] gy = SM2Param.getGy();
        int dPos = 2;
        System.arraycopy(id, 0, buffer, dPos, id.length);
        System.arraycopy(a, 0, buffer, dPos += id.length, 32);
        System.arraycopy(b, 0, buffer, dPos += 32, 32);
        System.arraycopy(gx, 0, buffer, dPos += 32, 32);
        System.arraycopy(gy, 0, buffer, dPos += 32, 32);
        System.arraycopy(x, 0, buffer, dPos += 32, 32);
        System.arraycopy(y, 0, buffer, dPos += 32, 32);
        dPos += 32;
        SM3Digest digest = new SM3Digest();
        digest.update(buffer, 0, buffer.length);
        byte[] out = new byte[32];
        digest.doFinal(out, 0);
        return out;
    }

    private static byte[] addId(BigInteger affineX, BigInteger affineY, byte[] id) {
        byte[] x = BigIntegerUtil.asUnsigned32ByteArray(affineX);
        byte[] y = BigIntegerUtil.asUnsigned32ByteArray(affineY);
        byte[] tmp = SM2HashZValue.getSM2Za(x, y, id);
        return tmp;
    }
}

