/*
 * Decompiled with CFR 0.152.
 */
package shade.org.apache.http.protocol;

import java.io.IOException;
import shade.org.apache.http.HttpException;
import shade.org.apache.http.HttpResponse;
import shade.org.apache.http.HttpResponseInterceptor;
import shade.org.apache.http.annotation.ThreadSafe;
import shade.org.apache.http.protocol.HttpContext;
import shade.org.apache.http.protocol.HttpDateGenerator;
import shade.org.apache.http.util.Args;

@ThreadSafe
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

