/*
 * Decompiled with CFR 0.152.
 */
package shade.org.apache.http.protocol;

import java.io.IOException;
import shade.org.apache.http.HttpEntity;
import shade.org.apache.http.HttpEntityEnclosingRequest;
import shade.org.apache.http.HttpException;
import shade.org.apache.http.HttpRequest;
import shade.org.apache.http.HttpRequestInterceptor;
import shade.org.apache.http.HttpVersion;
import shade.org.apache.http.ProtocolVersion;
import shade.org.apache.http.annotation.Immutable;
import shade.org.apache.http.protocol.HttpContext;
import shade.org.apache.http.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

