/*
 * Decompiled with CFR 0.152.
 */
package shade.org.apache.http.impl;

import java.util.Locale;
import shade.org.apache.http.HttpResponse;
import shade.org.apache.http.HttpResponseFactory;
import shade.org.apache.http.ProtocolVersion;
import shade.org.apache.http.ReasonPhraseCatalog;
import shade.org.apache.http.StatusLine;
import shade.org.apache.http.annotation.Immutable;
import shade.org.apache.http.impl.EnglishReasonPhraseCatalog;
import shade.org.apache.http.message.BasicHttpResponse;
import shade.org.apache.http.message.BasicStatusLine;
import shade.org.apache.http.protocol.HttpContext;
import shade.org.apache.http.util.Args;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

