/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.util;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XmlUtil {
    private static final Logger log = LoggerFactory.getLogger(XmlUtil.class);
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY;
    private static volatile JAXBContext jaxbContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JAXBContext getJaxbContext() {
        if (jaxbContext != null) return jaxbContext;
        Class<JAXBContext> clazz = JAXBContext.class;
        synchronized (JAXBContext.class) {
            if (jaxbContext != null) return jaxbContext;
            try {
                jaxbContext = JAXBContext.newInstance((String)"netbank.firm.server.dto");
            }
            catch (JAXBException e) {
                log.error("XmlUtil init error : ", e);
            }
            return jaxbContext;
        }
    }

    public static Unmarshaller getUnmarshaller() {
        try {
            Unmarshaller unmarshaller = XmlUtil.getJaxbContext().createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new NoValidationEventHandler());
            return unmarshaller;
        }
        catch (Exception e) {
            throw new RuntimeException("Jaxb Unmarshaller init error", e);
        }
    }

    public static Marshaller getMarshaller() {
        try {
            Marshaller m = XmlUtil.getJaxbContext().createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("jaxb.fragment", (Object)true);
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException("Jaxb Marshaller init error", e);
        }
    }

    public static <T> T toObject(Node node, Class<T> declaredType) throws JAXBException {
        JAXBElement obj = XmlUtil.getUnmarshaller().unmarshal(node, declaredType);
        return (T)obj.getValue();
    }

    public static String toXML(Object obj) throws JAXBException {
        StringWriter writer = new StringWriter();
        XmlUtil.getMarshaller().marshal(obj, (Writer)writer);
        return writer.toString();
    }

    public static Document parse(String xmlStrings) throws Exception {
        DocumentBuilder builder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        StringReader reader = new StringReader(xmlStrings);
        InputSource inputSource = new InputSource(reader);
        return builder.parse(inputSource);
    }

    static {
        log.info("Init DOM ...");
        try {
            DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
            DOCUMENT_BUILDER_FACTORY.setNamespaceAware(false);
            DOCUMENT_BUILDER_FACTORY.setIgnoringElementContentWhitespace(true);
            DOCUMENT_BUILDER_FACTORY.setIgnoringComments(true);
            DOCUMENT_BUILDER_FACTORY.setValidating(false);
        }
        catch (Exception e) {
            log.error("DocumentBuilderFactory init error: ", e);
            throw new RuntimeException("DocumentBuilderFactory init error: ", e);
        }
    }

    private static class NoValidationEventHandler
    implements ValidationEventHandler {
        private NoValidationEventHandler() {
        }

        public boolean handleEvent(ValidationEvent event) {
            return true;
        }
    }
}

