/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.util;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import shade.org.apache.commons.lang3.StringUtils;

public class MacUtil {
    public static final String DEFAULT_MAC_STR = "UNKNOWN-MAC-ADDRESS";

    public static String getLocalMac() throws SocketException, UnknownHostException {
        InetAddress ia = InetAddress.getLocalHost();
        String macAddr = DEFAULT_MAC_STR;
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> tmpMacList = new ArrayList<String>();
        block0: while (en.hasMoreElements()) {
            NetworkInterface iface = en.nextElement();
            List<InterfaceAddress> addrs = iface.getInterfaceAddresses();
            for (InterfaceAddress addr : addrs) {
                byte[] mac;
                InetAddress ip = addr.getAddress();
                NetworkInterface network = NetworkInterface.getByInetAddress(ip);
                if (network == null || (mac = network.getHardwareAddress()) == null) continue;
                sb.delete(0, sb.length());
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                String trimStr = sb.toString().replace("-", "").trim();
                if (trimStr.length() == 12) {
                    tmpMacList.add(sb.toString());
                }
                if (!StringUtils.equals(ia.getHostAddress(), ip.getHostAddress())) continue;
                macAddr = sb.toString();
                continue block0;
            }
        }
        if (tmpMacList.size() <= 0) {
            return DEFAULT_MAC_STR;
        }
        List unique = tmpMacList.stream().distinct().collect(Collectors.toList());
        if (unique.size() > 0 && StringUtils.equals(macAddr, DEFAULT_MAC_STR)) {
            macAddr = (String)unique.get(0);
        }
        return macAddr;
    }
}

