/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.org.apache.commons.lang.StringUtils;

public class CpuUtil {
    private static Logger log = LoggerFactory.getLogger(CpuUtil.class);
    private static String cpuID = "";

    public static String getCupId() {
        String property = System.getProperty("os.name");
        if (property.contains("Window")) {
            log.info("OS name is Windows.");
            if (StringUtils.isBlank(cpuID)) {
                try {
                    String line;
                    File file = File.createTempFile("getCpuId", ".vbs");
                    file.deleteOnExit();
                    FileWriter writer = new FileWriter(file);
                    String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n (\"Select * from Win32_Processor\") \nFor Each objItem in colItems \n Wscript.Echo objItem.ProcessorId \n exit for 'do the first cpu only! \n Next \n";
                    writer.write(vbs);
                    writer.close();
                    String path = file.getPath().replace("%20", "");
                    Process process = Runtime.getRuntime().exec("cscript //NoLogo " + path);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        cpuID = cpuID + line;
                    }
                    reader.close();
                    file.deleteOnExit();
                }
                catch (IOException e) {
                    log.info("Can not get CPUID: " + e.getMessage());
                }
            }
        } else if (property.contains("Linux")) {
            log.info("OS name is Linux.");
            try {
                cpuID = CpuUtil.getCpuIdforLinux();
            }
            catch (IOException e) {
                log.info("Can not get CPUID: Permission Denied!");
                cpuID = "No_Permission";
            }
        } else {
            log.info("OS name is " + property);
            cpuID = "(" + property + ")Cpuid_not_acquired.";
        }
        return cpuID;
    }

    public static String getCpuIdforLinux() throws IOException {
        String result = "";
        String[] linuxCommand = new String[]{"dmidecode", "-t", "processor", "|", "grep", "ID"};
        BufferedReader bufferedReader = null;
        Process p = null;
        p = Runtime.getRuntime().exec(linuxCommand);
        bufferedReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = null;
        int index = -1;
        while ((line = bufferedReader.readLine()) != null) {
            index = line.indexOf("ID");
            if (index < 0) continue;
            result = line.substring(index + "ID".length() + 1).trim();
            break;
        }
        if (StringUtils.isBlank(result)) {
            return "No_Permission";
        }
        return result.replace(" ", "");
    }

    public static void main(String[] args) {
        String p = "";
        try {
            p = CpuUtil.getCpuIdforLinux();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println(p);
    }
}

