/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.util;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import java.io.ByteArrayInputStream;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import netbank.firm.config.CibProfile;
import netbank.firm.dispatch.SslTypeEnum;
import netbank.firm.util.CertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import shaded.org.bouncycastle.util.encoders.Base64;

public class ChannelUtil {
    private static Logger log = LoggerFactory.getLogger(ChannelUtil.class);

    public static SslContext smSslContextMaker(String sslCerFilePath) throws Exception {
        return ChannelUtil.getBuilder(sslCerFilePath).build();
    }

    private static synchronized SslContextBuilder getBuilder(String sslCerFilePath) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        String certContent = CertUtil.getCertData(sslCerFilePath);
        X509Certificate[] x509Certificates = new X509Certificate[2];
        x509Certificates[0] = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(Base64.decode(certContent)));
        log.info("GM root cert has been created.");
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
        sslContextBuilder.sslProvider(SslProvider.BC);
        sslContextBuilder.trustManager(x509Certificates);
        return sslContextBuilder;
    }

    public static synchronized Certificate getCertificate(String sslCerFilePath) throws Exception {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        if (Security.getProvider("BCJSSE") == null) {
            Security.addProvider(new BouncyCastleJsseProvider("BC"));
        }
        String certContent = CertUtil.getCertData(sslCerFilePath);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        return certificateFactory.generateCertificate(new ByteArrayInputStream(Base64.decode(certContent)));
    }

    public static SslHandler getSslHandler(Channel ch, SslTypeEnum sslTypeEnum, CibProfile profile) throws Exception {
        return ChannelUtil.getSslHandler(ch, sslTypeEnum, profile, profile.getBankHost(), profile.getBankPort());
    }

    public static SslHandler getSslHandler(Channel ch, SslTypeEnum sslTypeEnum, CibProfile profile, String bankHost, int bankPort) throws Exception {
        SslContext sslCtx;
        if (SslTypeEnum.SM.equals((Object)sslTypeEnum)) {
            log.info("GM ssl is chosen.");
            CertUtil.addProviders();
            sslCtx = ChannelUtil.smSslContextMaker(profile.getSslCertFilePath());
        } else {
            log.info("Inter ssl is chosen.");
            sslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(SslProvider.JDK).build();
        }
        SslHandler sslHandler = sslCtx.newHandler(ch.alloc(), bankHost, bankPort);
        sslHandler.setHandshakeTimeout(60L, TimeUnit.SECONDS);
        AttributeKey sslFutureKey = AttributeKey.valueOf("SSL_FUTURE_KEY");
        Attribute<Future<Channel>> sslFutureValue = ch.attr(sslFutureKey);
        sslFutureValue.set(sslHandler.handshakeFuture());
        return sslHandler;
    }
}

