/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.service;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import netbank.firm.base.SystemProperty;
import netbank.firm.handler.AbstractNotifyMessageHandler4SDK;
import netbank.firm.handler.AbstractRequestFileHandler4SDK;
import netbank.firm.handler.DefaultListenChannelInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageListenService {
    private static final Logger LOG = LoggerFactory.getLogger(MessageListenService.class);
    private volatile Map<Integer, EventLoopGroup[]> shutList = new HashMap<Integer, EventLoopGroup[]>();
    final ReentrantLock lock = new ReentrantLock();
    private String listenHost;
    private int listenPort;
    private String revcPath;

    public MessageListenService() {
    }

    public MessageListenService(String listenHost, int listenPort, String revcPath, AbstractNotifyMessageHandler4SDK notifyMessageHandler, AbstractRequestFileHandler4SDK requestFileHandler) {
        this.listenHost = listenHost;
        this.listenPort = listenPort;
        this.revcPath = revcPath;
    }

    public boolean isStarted() {
        boolean result = true;
        if (this.shutList.get(this.listenPort) != null) {
            EventLoopGroup[] eg = this.shutList.get(this.listenPort);
            if (eg.length != 2 || eg[0].isShutdown() || eg[0].isShuttingDown() || eg[1].isShutdown() || eg[1].isShuttingDown()) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    private void init() throws Exception {
        this.listenHost = SystemProperty.getInstance().getProperty("listen.host", true);
        this.listenPort = Integer.parseInt(SystemProperty.getInstance().getProperty("listen.port", true));
        this.revcPath = SystemProperty.getInstance().getProperty("file.receive.path", true);
    }

    public boolean startListen() throws Exception {
        this.init();
        StringBuffer notifyMsg = new StringBuffer();
        CountDownLatch startSignal = new CountDownLatch(1);
        DefaultListenChannelInitializer sc = new DefaultListenChannelInitializer(this.revcPath);
        WorkThread thread = new WorkThread(notifyMsg, sc, startSignal, this.listenHost, this.listenPort);
        try {
            thread.start();
            startSignal.await();
            boolean result = Boolean.valueOf(notifyMsg.toString());
            if (result) {
                LOG.info("\u6210\u529f\u76d1\u542c\uff1a" + this.listenPort);
            } else {
                LOG.info("\u76d1\u542c\u5931\u8d25\uff1a" + this.listenPort);
            }
            return result;
        }
        catch (Exception e) {
            LOG.error("\u542f\u52a8\u76d1\u542c\u670d\u52a1\u5f02\u5e38\uff1a", e);
            return false;
        }
    }

    public boolean stopListen() {
        try {
            this.lock.lock();
            if (this.shutList.get(this.listenPort) != null) {
                EventLoopGroup[] eg = this.shutList.get(this.listenPort);
                eg[0].shutdownGracefully();
                eg[1].shutdownGracefully();
                this.shutList.remove(this.listenPort);
                LOG.info("\u5173\u95ed\u76d1\u542c\uff1a" + this.listenPort);
            }
            boolean eg = true;
            return eg;
        }
        catch (Exception e) {
            LOG.error("\u5173\u95ed\u76d1\u542c\u5931\u8d25\uff1a" + e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<Integer, EventLoopGroup[]> getShutList() {
        return this.shutList;
    }

    public void setShutList(Map<Integer, EventLoopGroup[]> shutList) {
        this.shutList = shutList;
    }

    public String getListenHost() {
        return this.listenHost;
    }

    public void setListenHost(String listenHost) {
        this.listenHost = listenHost;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public String getRevcPath() {
        return this.revcPath;
    }

    public void setRevcPath(String revcPath) {
        this.revcPath = revcPath;
    }

    private class WorkThread
    extends Thread {
        StringBuffer result;
        private ChannelInitializer<SocketChannel> sc;
        CountDownLatch startSignal;
        String host;
        Integer listen;

        WorkThread(StringBuffer result, ChannelInitializer<SocketChannel> sc, CountDownLatch startSignal, String host, Integer listen) {
            this.result = result;
            this.sc = sc;
            this.startSignal = startSignal;
            this.host = host;
            this.listen = listen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int bossSize = Integer.parseInt(SystemProperty.getInstance().getProperty("netty.boss.group.size", "1"));
            int workSize = Integer.parseInt(SystemProperty.getInstance().getProperty("netty.boss.group.size", "0"));
            NioEventLoopGroup bossGroup = new NioEventLoopGroup(bossSize);
            NioEventLoopGroup workerGroup = new NioEventLoopGroup(workSize);
            try {
                ServerBootstrap b = new ServerBootstrap();
                ((ServerBootstrap)((ServerBootstrap)b.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).handler(new LoggingHandler(LogLevel.INFO))).childHandler(this.sc);
                try {
                    MessageListenService.this.lock.lock();
                    EventLoopGroup[] eg = new EventLoopGroup[]{bossGroup, workerGroup};
                    MessageListenService.this.shutList.put(this.listen, eg);
                }
                finally {
                    MessageListenService.this.lock.unlock();
                }
                ChannelFuture f = b.bind(this.host, (int)this.listen).sync();
                this.result = this.result.append("true");
                this.startSignal.countDown();
                f.channel().closeFuture().sync();
            }
            catch (Exception e) {
                this.result = this.result.append("false");
                this.startSignal.countDown();
                LOG.error(e.getMessage(), e);
                throw new RuntimeException(e);
            }
            finally {
                if (!bossGroup.isShutdown()) {
                    bossGroup.shutdownGracefully();
                }
                if (!workerGroup.isShutdown()) {
                    workerGroup.shutdownGracefully();
                }
            }
        }
    }
}

