/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.service;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.TimeUnit;
import netbank.firm.base.CFCASignature;
import netbank.firm.base.SystemProperty;
import netbank.firm.config.CibProfile;
import netbank.firm.dispatch.FileServerDispatcher;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.handler.DcfirmChannelPromise;
import netbank.firm.handler.DefaultFileChannelInitializer;
import netbank.firm.handler.DefaultRequestFileHandler;
import netbank.firm.handler.DefaultResponseFileHandler;
import netbank.firm.model.gmmodel.GmDownloadRequest;
import netbank.firm.model.gmmodel.GmDownloadRequestV2;
import netbank.firm.model.gmmodel.GmUploadRequest;
import netbank.firm.model.gmmodel.GmUploadRequestV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.org.apache.commons.lang.StringUtils;

public class FileService {
    private static final Logger LOG = LoggerFactory.getLogger(FileService.class);
    private boolean initFlag;
    private CibProfile profile;
    private static final long FILE_MAX_SIZE = 0xC800000L;

    private synchronized void init() throws DcfirmException {
        if (!this.initFlag) {
            try {
                if (this.profile == null) {
                    this.profile = new CibProfile();
                }
                if (StringUtils.isEmpty(this.profile.getBankHost())) {
                    this.profile.setBankHost(SystemProperty.getInstance().getProperty("bank.host", true));
                }
                if (this.profile.getBankPort() <= 0) {
                    this.profile.setBankPort(Integer.parseInt(SystemProperty.getInstance().getProperty("bank.port", true)));
                }
                if (StringUtils.isEmpty(this.profile.getProxyHost())) {
                    this.profile.setProxyHost(SystemProperty.getInstance().getProperty("proxy.host", true));
                }
                if (this.profile.getProxyPort() <= 0) {
                    this.profile.setProxyPort(Integer.parseInt(SystemProperty.getInstance().getProperty("proxy.port", true)));
                }
                if (this.profile.getBlockSize() <= 0) {
                    this.profile.setBlockSize(Integer.parseInt(SystemProperty.getInstance().getProperty("file.transfer.blockSize", "4096")));
                }
                if (this.profile.getStartBlockId() <= 0) {
                    this.profile.setStartBlockId(Integer.parseInt(SystemProperty.getInstance().getProperty("file.transfer.startBlockId", "1")));
                }
                if (StringUtils.isEmpty(this.profile.getNcid())) {
                    this.profile.setNcid(SystemProperty.getInstance().getProperty("ncid", true));
                }
                if (this.profile.getConnectionTimeOut() <= 0) {
                    this.profile.setConnectionTimeOut(Integer.parseInt(SystemProperty.getInstance().getProperty("netty.connection.outtime.seconds", "60")));
                }
            }
            catch (Exception e) {
                throw new DcfirmException(ExceptionCode.C004.getCode(), e.getMessage());
            }
            if (this.profile.getBlockSize() >= 1024 && this.profile.getBlockSize() <= 8192) {
                if (this.profile.getStartBlockId() < 1) {
                    throw new DcfirmException(ExceptionCode.C004.getCode(), "startNum must be lager than 1");
                }
            } else {
                throw new DcfirmException(ExceptionCode.C004.getCode(), "block size between 1024 and 8192");
            }
            this.initFlag = true;
        }
    }

    public FileService() {
    }

    public FileService(CibProfile profile) {
        this.profile = profile;
    }

    public String uploadFile(final String bizCode, final File sendFile) throws DcfirmException {
        String fileId;
        LOG.info("dcfirmsdk version: 2.3");
        LOG.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a1.\u5ba2\u6237\u6a21\u5f0f:SDK\u6709\u524d\u7f6e");
        LOG.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a2.\u5ba2\u6237\u884c\u4e3a:\u6587\u4ef6\u4e0a\u4f20");
        if (bizCode == null || "".equals(bizCode)) {
            throw new DcfirmException(ExceptionCode.B100.getCode(), "bizCode can not be empty or null");
        }
        if (sendFile == null || !sendFile.exists() || sendFile.isDirectory()) {
            throw new DcfirmException(ExceptionCode.C005);
        }
        this.checkFileLength(sendFile);
        this.init();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).handler(new DefaultFileChannelInitializer())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.profile.getConnectionTimeOut() * 1000);
            ChannelFuture ch = bootstrap.connect(this.profile.getProxyHost(), this.profile.getProxyPort()).sync();
            DcfirmChannelPromise promise = new DcfirmChannelPromise(ch.channel());
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        throw new DcfirmException(ExceptionCode.B214, future.cause());
                    }
                }
            });
            this.appendResponseFileHandler(ch, sendFile, (DefaultChannelPromise)promise);
            ch.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        LOG.error("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a3.\u7f51\u7edc\u8fde\u63a5:" + FileService.this.profile.getProxyHost() + ":" + FileService.this.profile.getProxyPort() + "\u8fde\u63a5\u5931\u8d25", future.cause());
                        throw new DcfirmException(ExceptionCode.C001.getCode(), future.cause().toString());
                    }
                    LOG.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a3.\u7f51\u7edc\u8fde\u63a5:" + FileService.this.profile.getProxyHost() + ":" + FileService.this.profile.getProxyPort() + "\u8fde\u63a5\u6210\u529f");
                    String fileName = sendFile.getName();
                    String body = fileName.substring(fileName.lastIndexOf(92) + 1);
                    GmUploadRequest auth = new GmUploadRequest(bizCode, body);
                    future.channel().writeAndFlush(auth).addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                }
            });
            ch.channel().closeFuture().addListener(f -> {
                if (0L == promise.flushCheckpoint()) {
                    promise.setFailure(new Exception("\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
                }
            });
            promise.sync();
            AttributeKey ak = AttributeKey.valueOf("FileID");
            fileId = (String)ch.channel().attr(ak).get();
            LOG.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a4.\u6587\u4ef6\u4e0a\u4f20\u7ed3\u679c: fileID: " + fileId + ", fileName: " + sendFile.getName() + "\uff0c\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
            ch.channel().closeFuture().sync();
        }
        catch (Exception e) {
            LOG.error("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a4.\u6587\u4ef6\u4e0a\u4f20\u7ed3\u679c: fileName: " + sendFile.getName() + "\uff0c\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", e);
            throw new DcfirmException(ExceptionCode.C002.getCode(), e.getMessage());
        }
        finally {
            group.shutdownGracefully();
        }
        return fileId;
    }

    public String uploadFile_noMBFE(String bizCode, String filePath) throws DcfirmException {
        String fileId;
        LOG.info("dcfirmsdk version: 2.3");
        LOG.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a1.\u5ba2\u6237\u6a21\u5f0f:SDK\u65e0\u524d\u7f6e");
        LOG.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a2.\u5ba2\u6237\u884c\u4e3a:\u6587\u4ef6\u4e0a\u4f20");
        if (bizCode == null || "".equals(bizCode)) {
            throw new DcfirmException(ExceptionCode.B100.getCode(), "bizCode can not be empty or null");
        }
        if (filePath == null || "".equals(filePath)) {
            throw new DcfirmException(ExceptionCode.B100.getCode(), "filePath can not be empty or null");
        }
        File sendFile = new File(filePath);
        if (!sendFile.exists() || sendFile.isDirectory()) {
            throw new DcfirmException(ExceptionCode.C005);
        }
        this.checkFileLength(sendFile);
        this.init();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            Channel channel = FileServerDispatcher.connectRemoteServer(group, this.profile);
            DcfirmChannelPromise promise = new DcfirmChannelPromise(channel);
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        throw new DcfirmException(ExceptionCode.B214, future.cause());
                    }
                }
            });
            this.appendResponseFileHandler(channel, sendFile, (DefaultChannelPromise)promise);
            String fileName = sendFile.getName();
            String body = fileName.substring(fileName.lastIndexOf(92) + 1);
            GmUploadRequestV2 auth = new GmUploadRequestV2(bizCode, body);
            CFCASignature signatureUtil = new CFCASignature();
            signatureUtil.setProfile(this.profile);
            String signData = signatureUtil.signature(body);
            auth.setNcid(this.profile.getNcid());
            auth.setSignature(signData);
            channel.writeAndFlush(auth).addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            promise.sync();
            AttributeKey ak = AttributeKey.valueOf("FileID");
            fileId = (String)channel.attr(ak).get();
            LOG.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a5.\u6587\u4ef6\u4e0a\u4f20\u7ed3\u679c:[{}]\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0cfilemac\uff1a[{}]", (Object)fileName, (Object)fileId);
            channel.closeFuture().sync();
        }
        catch (Exception var14) {
            LOG.error("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a5.\u6587\u4ef6\u4e0a\u4f20\u7ed3\u679c:[{}]\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a", (Object)sendFile.getName(), (Object)var14);
            throw new DcfirmException(ExceptionCode.C002.getCode(), var14.getMessage());
        }
        finally {
            group.shutdownGracefully();
        }
        return fileId;
    }

    public String downloadFileWithSync(final String fileName, final String fileId) throws DcfirmException {
        LOG.info("dcfirmsdk version: 2.3");
        if (fileId == null || "".equals(fileId)) {
            throw new DcfirmException(ExceptionCode.B100.getCode(), "fileId can not be empty or null");
        }
        if (fileName == null || "".equals(fileName)) {
            throw new DcfirmException(ExceptionCode.B100.getCode(), "fileName can not be empty or null");
        }
        String filePath = "";
        this.init();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).handler(new DefaultFileChannelInitializer())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.profile.getConnectionTimeOut() * 1000);
            ChannelFuture ch = bootstrap.connect(this.profile.getProxyHost(), this.profile.getProxyPort()).sync();
            DcfirmChannelPromise promise = new DcfirmChannelPromise(ch.channel());
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        throw new DcfirmException(ExceptionCode.B214, future.cause());
                    }
                }
            });
            this.appendRequestFileHandler(ch, (ChannelPromise)promise);
            this.appendResponseFileHandler(ch, null, (DefaultChannelPromise)promise);
            ch.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        LOG.error("error: ", future.cause());
                        throw new DcfirmException(ExceptionCode.B001.getCode(), future.cause().toString());
                    }
                    GmDownloadRequest downLoadRequest = new GmDownloadRequest();
                    downLoadRequest.setFileId(fileId);
                    downLoadRequest.setFileName(fileName);
                    downLoadRequest.setStartNum(FileService.this.profile.getStartBlockId());
                    downLoadRequest.setBlockSize(FileService.this.profile.getBlockSize());
                    future.channel().writeAndFlush(downLoadRequest).addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                }
            });
            promise.sync();
            ch.channel().closeFuture().sync();
            AttributeKey ak = AttributeKey.valueOf("recvFile");
            filePath = (String)ch.channel().attr(ak).get();
            if (filePath.substring(0, filePath.indexOf(".gz")) != null) {
                filePath = filePath.substring(0, filePath.indexOf(".gz"));
            }
        }
        catch (Exception var13) {
            LOG.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a", var13);
            throw new DcfirmException(ExceptionCode.C002.getCode(), var13.getMessage());
        }
        finally {
            group.shutdownGracefully();
        }
        return filePath;
    }

    public String downloadFile(String fileName, String fileId) throws DcfirmException {
        return this.downloadFile(fileName, fileId, 0L);
    }

    public String downloadFile_noMBFE(String fileName, String fileId) throws DcfirmException {
        return this.downloadFile_noMBFE(fileName, fileId, 0L);
    }

    private String downloadFile_noMBFE(String fileName, String fileId, long promiseTimeOut) throws DcfirmException {
        LOG.info("dcfirmsdk version: 2.3");
        LOG.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a1.\u5ba2\u6237\u6a21\u5f0f:SDK\u65e0\u524d\u7f6e");
        LOG.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a2.\u5ba2\u6237\u884c\u4e3a:\u6587\u4ef6\u4e0b\u8f7d");
        String filePath = "";
        this.init();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            Channel channel = FileServerDispatcher.connectRemoteServer(group, this.profile);
            DcfirmChannelPromise promise = new DcfirmChannelPromise(channel);
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        throw new DcfirmException(ExceptionCode.B214, future.cause());
                    }
                }
            });
            this.appendRequestFileHandler(channel, (ChannelPromise)promise);
            this.appendResponseFileHandler(channel, null, (DefaultChannelPromise)promise);
            CFCASignature signatureUtil = new CFCASignature();
            signatureUtil.setProfile(this.profile);
            String signData = signatureUtil.signature(fileId);
            GmDownloadRequestV2 downLoadRequest = new GmDownloadRequestV2();
            downLoadRequest.setNcid(this.profile.getNcid());
            downLoadRequest.setSignature(signData);
            downLoadRequest.setFileId(fileId);
            downLoadRequest.setFileName(fileName);
            downLoadRequest.setStartNum(this.profile.getStartBlockId());
            downLoadRequest.setBlockSize(this.profile.getBlockSize());
            channel.writeAndFlush(downLoadRequest).addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            if (promiseTimeOut != 0L) {
                promise.await(promiseTimeOut, TimeUnit.SECONDS);
            }
            channel.closeFuture().sync();
            AttributeKey ak = AttributeKey.valueOf("recvFile");
            filePath = (String)channel.attr(ak).get();
            LOG.error("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a5.\u6587\u4ef6\u4e0b\u8f7d\u7ed3\u679c:[{}]\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f\uff0cfilePath\uff1a[{}]", (Object)fileName, (Object)filePath);
        }
        catch (Exception var15) {
            LOG.error("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a5.\u6587\u4ef6\u4e0b\u8f7d\u7ed3\u679c:[{}]\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a", (Object)fileName, (Object)var15);
            throw new DcfirmException(ExceptionCode.C002.getCode(), var15.getMessage());
        }
        finally {
            group.shutdownGracefully();
        }
        return filePath;
    }

    private String downloadFile(final String fileName, final String fileId, long promiseTimeOut) throws DcfirmException {
        LOG.info("dcfirmsdk version: 2.3");
        LOG.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a1.\u5ba2\u6237\u6a21\u5f0f:SDK\u6709\u524d\u7f6e");
        LOG.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a2.\u5ba2\u6237\u884c\u4e3a:\u6587\u4ef6\u4e0b\u8f7d");
        String filePath = "";
        this.init();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).handler(new DefaultFileChannelInitializer())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.profile.getConnectionTimeOut() * 1000);
            ChannelFuture ch = bootstrap.connect(this.profile.getProxyHost(), this.profile.getProxyPort()).sync();
            DcfirmChannelPromise promise = new DcfirmChannelPromise(ch.channel());
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        throw new DcfirmException(ExceptionCode.B214, future.cause());
                    }
                }
            });
            this.appendRequestFileHandler(ch, (ChannelPromise)promise);
            this.appendResponseFileHandler(ch, (File)null, (DefaultChannelPromise)promise);
            ch.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        LOG.error("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a3.\u7f51\u7edc\u8fde\u63a5:" + FileService.this.profile.getProxyHost() + ":" + FileService.this.profile.getProxyPort() + "\u8fde\u63a5\u5931\u8d25", future.cause());
                        throw new DcfirmException(ExceptionCode.C001.getCode(), future.cause().toString());
                    }
                    LOG.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a3.\u7f51\u7edc\u8fde\u63a5:" + FileService.this.profile.getProxyHost() + ":" + FileService.this.profile.getProxyPort() + "\u8fde\u63a5\u6210\u529f");
                    GmDownloadRequest downLoadRequest = new GmDownloadRequest();
                    downLoadRequest.setFileId(fileId);
                    downLoadRequest.setFileName(fileName);
                    downLoadRequest.setStartNum(FileService.this.profile.getStartBlockId());
                    downLoadRequest.setBlockSize(FileService.this.profile.getBlockSize());
                    future.channel().writeAndFlush(downLoadRequest).addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                }
            });
            if (promiseTimeOut != 0L) {
                promise.await(promiseTimeOut, TimeUnit.SECONDS);
            }
            ch.channel().closeFuture().sync();
            AttributeKey ak = AttributeKey.valueOf("recvFile");
            filePath = (String)ch.channel().attr(ak).get();
            LOG.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a4.\u6587\u4ef6\u4e0b\u8f7d\u7ed3\u679c: filePath: " + filePath + "\uff0c\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f");
        }
        catch (Exception e) {
            LOG.error("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a4.\u6587\u4ef6\u4e0b\u8f7d\u7ed3\u679c: " + fileName + "\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", e);
            throw new DcfirmException(ExceptionCode.C002.getCode(), e.getMessage());
        }
        finally {
            group.shutdownGracefully();
        }
        return filePath;
    }

    private void appendResponseFileHandler(ChannelFuture ch, File sendFile, DefaultChannelPromise promise) throws Exception {
        this.appendResponseFileHandler(ch.channel(), sendFile, promise);
    }

    private void appendResponseFileHandler(Channel channel, File sendFile, DefaultChannelPromise promise) throws Exception {
        ChannelPipeline p = channel.pipeline();
        DefaultResponseFileHandler responseFileHandler = new DefaultResponseFileHandler();
        if (sendFile != null) {
            if (!sendFile.exists()) {
                throw new FileNotFoundException();
            }
            responseFileHandler.setSendFile(sendFile);
            responseFileHandler.setBlockSize(this.profile.getBlockSize());
            responseFileHandler.setStartBlockId(this.profile.getStartBlockId());
        }
        responseFileHandler.setPromise(promise);
        promise.flushCheckpoint(0L);
        p.addLast("sendFile", (ChannelHandler)responseFileHandler);
    }

    private void appendRequestFileHandler(ChannelFuture channelFuture, ChannelPromise promise) throws Exception {
        this.appendRequestFileHandler(channelFuture.channel(), promise);
    }

    private void appendRequestFileHandler(Channel channel, ChannelPromise promise) throws Exception {
        ChannelPipeline p = channel.pipeline();
        String receivePath = SystemProperty.getInstance().getProperty("file.receive.path", true);
        DefaultRequestFileHandler requestFileHandler = new DefaultRequestFileHandler();
        requestFileHandler.setPath(receivePath);
        requestFileHandler.setPromise(promise);
        p.addLast("re", (ChannelHandler)requestFileHandler);
    }

    private void checkFileLength(File file) throws DcfirmException {
        long fileLength = file.length();
        if (fileLength > 0xC800000L) {
            throw new DcfirmException(ExceptionCode.C004.getCode(), "\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u6700\u5927\u503c[209715200]");
        }
    }
}

