/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.server.service;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.util.AttributeKey;
import java.net.URI;
import netbank.firm.config.CibProfile;
import netbank.firm.dispatch.CibDispatcher;
import netbank.firm.handler.CibOnlineServerBackendHandler;
import netbank.firm.handler.DcfirmChannelPromise;
import netbank.firm.server.dto.QueryDcConfigRequestBean;
import netbank.firm.server.dto.QueryDcConfigResponseBean;
import netbank.firm.server.dto.RequestBean;
import netbank.firm.server.service.BaseService;
import netbank.firm.util.ContentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigService
extends BaseService {
    private static final Logger log = LoggerFactory.getLogger(ConfigService.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QueryDcConfigResponseBean.ResponseBody queryConfig(CibProfile profile) throws Exception {
        try {
            RequestBean<QueryDcConfigRequestBean> requestBean = new RequestBean<QueryDcConfigRequestBean>();
            requestBean.setSignOn(ConfigService.getCommonSignOn(profile));
            QueryDcConfigRequestBean requestBody = new QueryDcConfigRequestBean();
            requestBody.setCurrentVersion("CL_v2.1.1");
            requestBody.setSystemType(ContentUtil.getSystemTypeCode() + "");
            requestBody.setTrnuId(System.currentTimeMillis() + "");
            requestBean.setRequestBody(requestBody);
            String requestBodyXml = requestBean.toXmlString();
            log.info("queryConfig request:{}", (Object)requestBodyXml);
            NioEventLoopGroup group = new NioEventLoopGroup(1);
            try {
                Channel channel = CibDispatcher.connectRemoteServer(group, profile);
                DefaultFullHttpRequest fullHttpRequest = ContentUtil.buildRequestBean(requestBodyXml, new URI(profile.getServiceUrl()), profile);
                fullHttpRequest.headers().set("No-Login", (Object)"true");
                DcfirmChannelPromise promise = new DcfirmChannelPromise(channel);
                channel.pipeline().addLast("responseHandler", (ChannelHandler)new CibOnlineServerBackendHandler(profile, promise));
                channel.writeAndFlush(fullHttpRequest).addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                promise.sync();
                if (!promise.isSuccess()) {
                    throw new Exception(promise.cause());
                }
                AttributeKey ak = AttributeKey.valueOf("RESPONSE_CONTENT_KEY");
                String response = (String)channel.attr(ak).get();
                log.info("\u54cd\u5e94\u62a5\u6587[\r\n" + response + "\r\n]");
                QueryDcConfigResponseBean responseBean = ConfigService.extraResponse(response, QueryDcConfigResponseBean.tagName(), QueryDcConfigResponseBean.class);
                if (responseBean == null) throw new Exception("\u67e5\u8be2\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                if (responseBean.getResponseBody() == null) throw new Exception("\u67e5\u8be2\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                if (responseBean.getStatus() == null) {
                    throw new Exception("\u67e5\u8be2\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                if (!responseBean.getStatus().isSuccess()) {
                    throw new Exception(responseBean.getStatus().getMessage());
                }
                QueryDcConfigResponseBean.ResponseBody responseBody = responseBean.getResponseBody();
                return responseBody;
            }
            catch (Exception e) {
                log.error("\u53d1\u751f\u9519\u8bef.\r\nerror:" + e.getMessage());
                throw e;
            }
            finally {
                group.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.error("queryConfig error: ", e);
            throw new Exception("\u67e5\u8be2\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }
}

