/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.model.gmmodel;

import netbank.firm.model.FileRequest;
import netbank.firm.model.FileRequestType;
import netbank.firm.model.gmmodel.GmMessageHead;
import netbank.firm.serial.AlignType;
import netbank.firm.serial.FieldDefine;
import netbank.firm.serial.HeadType;
import netbank.firm.serial.Serialable;
import netbank.firm.serial.TxnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Serialable(headType=HeadType.GmMessageV2, txnModel=TxnModel.GM_DOWNLOAD_REQUEST_V2)
public class GmDownloadRequestV2
extends FileRequest<GmDownloadRequestV2> {
    @FieldDefine(length=15, order=5)
    private String fileId;
    @FieldDefine(length=64, order=6)
    private String fileName;
    @FieldDefine(length=5, order=10, align=AlignType.RIGHT)
    private Integer blockSize;
    @FieldDefine(length=5, order=15, align=AlignType.RIGHT)
    private Integer startNum;
    @FieldDefine(length=1, order=18)
    private String messageBizType;
    @FieldDefine(length=-1, order=20)
    private String signature;

    public GmDownloadRequestV2(GmMessageHead head, byte[] body) {
        super(FileRequestType.GM_DOWNLOAD_V2);
        this.fileId = new String(body, 0, 15);
        this.fileName = new String(body, 15, 64);
        this.blockSize = new Integer(new String(body, 79, 5).trim());
        this.startNum = new Integer(new String(body, 84, 5).trim());
    }

    public GmDownloadRequestV2() {
        super(FileRequestType.GM_DOWNLOAD_V2);
        this.messageBizType = "G";
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(Integer blockSize) {
        this.blockSize = blockSize;
    }

    public Integer getStartNum() {
        return this.startNum;
    }

    public void setStartNum(Integer startNum) {
        this.startNum = startNum;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getMessageBizType() {
        return this.messageBizType;
    }

    public void setMessageBizType(String messageBizType) {
        this.messageBizType = messageBizType;
    }
}

