/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.handler;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutHandler
extends ChannelDuplexHandler {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)evt;
            this.LOG.info("\u7ba1\u9053id:" + ctx.channel().id());
            if (e.state() == IdleState.ALL_IDLE) {
                this.LOG.error("\u89e6\u53d1\u4e86\u8d85\u65f6\u4e8b\u4ef6");
                ctx.close();
                ctx.fireExceptionCaught(new DcfirmException(ExceptionCode.S003));
            }
            if (e.state() == IdleState.READER_IDLE) {
                this.LOG.error("\u89e6\u53d1\u4e86\u8bfb\u8d85\u65f6\u4e8b\u4ef6");
                ctx.close();
                ctx.fireExceptionCaught(new DcfirmException(ExceptionCode.S001));
            }
            if (e.state() == IdleState.WRITER_IDLE) {
                this.LOG.error("\u89e6\u53d1\u4e86\u5199\u8d85\u65f6\u4e8b\u4ef6");
                ctx.close();
                ctx.fireExceptionCaught(new DcfirmException(ExceptionCode.S002));
            }
        }
    }
}

