/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.util.AttributeKey;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import netbank.firm.base.CFCASignature;
import netbank.firm.config.CibProfile;
import netbank.firm.dispatch.CibDispatcher;
import netbank.firm.handler.CibOnlineServerBackendHandler;
import netbank.firm.handler.DcfirmChannelPromise;
import netbank.firm.service.MessageService;
import netbank.firm.util.ChannelUtil;
import netbank.firm.util.ContentUtil;
import netbank.firm.util.CpuUtil;
import netbank.firm.util.MacUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.org.apache.commons.lang.StringUtils;
import shade.org.apache.http.Consts;
import shade.org.apache.http.HttpEntity;
import shade.org.apache.http.StatusLine;
import shade.org.apache.http.client.HttpResponseException;
import shade.org.apache.http.client.config.RequestConfig;
import shade.org.apache.http.client.methods.CloseableHttpResponse;
import shade.org.apache.http.client.methods.HttpPost;
import shade.org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import shade.org.apache.http.conn.ssl.NoopHostnameVerifier;
import shade.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import shade.org.apache.http.entity.StringEntity;
import shade.org.apache.http.impl.client.CloseableHttpClient;
import shade.org.apache.http.impl.client.HttpClients;
import shade.org.apache.http.util.EntityUtils;

public class MessageServiceHandler
implements MessageService {
    private static Logger log = LoggerFactory.getLogger(MessageServiceHandler.class);
    private CibProfile profile;

    public MessageServiceHandler() {
    }

    public MessageServiceHandler(CibProfile profile) {
        this.profile = profile;
    }

    public void setProfile(CibProfile profile) {
        this.profile = profile;
    }

    @Override
    public CibProfile getProfile() {
        return this.profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectable() {
        boolean context;
        HttpURLConnection conn = null;
        try {
            URL ex = new URL(this.profile.getServiceUrl());
            conn = (HttpURLConnection)ex.openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(15000);
            if (conn instanceof HttpsURLConnection) {
                SSLContext context1 = SSLContext.getInstance("TLS");
                context1.init(null, new TrustManager[]{new EasyTrustManager()}, null);
                HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
                httpsConn.setSSLSocketFactory(context1.getSocketFactory());
                httpsConn.setHostnameVerifier(new AllowAllHostnameVerifier());
            }
            conn.connect();
            boolean bl = true;
            return bl;
        }
        catch (Exception var8) {
            log.error("\u8054\u901a[" + this.profile.getServiceUrl() + "]\u68c0\u67e5\u9519\u8bef", var8);
            context = false;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return context;
    }

    @Override
    public String postData_noMBFE(String content) throws Exception {
        String responseBody;
        log.info("dcfirmsdk version: 2.3");
        if (StringUtils.isEmpty(content)) {
            throw new Exception("Request content can not empty or null.");
        }
        String logContent = content.replaceAll("<USERPASS>\\S*</USERPASS>", "<USERPASS>******</USERPASS>");
        content = ContentUtil.encryptPassword(content, this.profile);
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null, null);
        trustStore.setCertificateEntry("ca1", ChannelUtil.getCertificate(this.profile.getSslCertFilePath()));
        TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
        trustMgrFact.init(trustStore);
        SSLContext ctx = SSLContext.getInstance("GMTLSV1.1");
        ctx.init(null, trustMgrFact.getTrustManagers(), null);
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        try (CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).setMaxConnTotal(10).build();){
            RequestConfig ex = RequestConfig.custom().setSocketTimeout(this.profile.getTimeOut() * 1000).setConnectTimeout(this.profile.getTimeOut() * 1000).build();
            HttpPost httpPost = new HttpPost(this.profile.getServiceUrl());
            httpPost.setConfig(ex);
            CFCASignature signature = new CFCASignature();
            signature.setProfile(this.profile);
            String signedData = signature.signature(content);
            if (log.isDebugEnabled()) {
                log.debug("\u7b7e\u540d\u6e90\u6570\u636e[" + logContent + "],\r\n\u7b7e\u540d\u6570\u636e[" + signedData + "]");
            }
            String pattern = "\\r\\n|\\r|\\n|\\t";
            String macAddress = MacUtil.getLocalMac();
            String cpuId = CpuUtil.getCupId();
            String javaVmInfo = System.getProperty("java.vm.info").replaceAll(pattern, " ");
            String javaVersion = System.getProperty("java.version").replaceAll(pattern, " ");
            String osName = System.getProperty("os.name").replaceAll(pattern, " ");
            String osVersion = System.getProperty("os.version").replaceAll(pattern, " ");
            String osArch = System.getProperty("os.arch").replaceAll(pattern, " ");
            String userCountry = System.getProperty("user.country").replaceAll(pattern, " ");
            String userLanguage = System.getProperty("user.language").replaceAll(pattern, " ");
            httpPost.setHeader("DClient-Version", "CFCA-V3");
            httpPost.setHeader("Soft-Version", "ClientLess_v2.1.1");
            httpPost.setHeader("Content-Type", "text/xml; charset=GB18030");
            httpPost.setHeader("Connection", "Close");
            httpPost.setHeader("Intensoft-Sign", "PKCS12");
            httpPost.setHeader("ONE_STEP", "YES");
            httpPost.setHeader("Entrust-Client", "SOFT_CERT");
            httpPost.setHeader("User_Agent", javaVmInfo + "; " + javaVersion + "; " + osName + "; " + osVersion + "; " + osArch + "; " + userCountry + "; " + userLanguage);
            httpPost.setHeader("Mac_Addr", macAddress);
            httpPost.setHeader("CPU_Info", cpuId);
            StringEntity stringEntity = new StringEntity(signedData, Consts.UTF_8);
            stringEntity.setContentType("application/x-www-form-urlencoded");
            httpPost.setEntity(stringEntity);
            CloseableHttpResponse response = httpclient.execute(httpPost);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() >= 300) {
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            HttpEntity entity = response.getEntity();
            responseBody = EntityUtils.toString(entity);
            log.info("\u5ba2\u6237\u7aef\u8bf7\u6c42\u62a5\u6587[\r\n" + logContent + "\r\n], \u94f6\u884c\u7aef\u54cd\u5e94\u62a5\u6587[\r\n" + responseBody + "\r\n]");
            EntityUtils.consume(entity);
        }
        return responseBody;
    }

    @Override
    public String postDataNoMBFEByNetty(String content) throws Exception {
        String response;
        log.info("dcfirmsdk version: 2.3");
        if (StringUtils.isEmpty(content)) {
            throw new Exception("Request content can not empty or null.");
        }
        String logContent = content.replaceAll("<USERPASS>\\S*</USERPASS>", "<USERPASS>******</USERPASS>");
        log.info("\u5ba2\u6237\u7aef\u8bf7\u6c42\u62a5\u6587\r\n{}", (Object)logContent);
        content = ContentUtil.encryptPassword(content, this.profile);
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            Channel channel = CibDispatcher.connectRemoteServer(group, this.profile);
            DefaultFullHttpRequest fullHttpRequest = ContentUtil.buildRequestBean(content, new URI(this.profile.getServiceUrl()), this.profile);
            DcfirmChannelPromise promise = new DcfirmChannelPromise(channel);
            channel.pipeline().addLast("responseHandler", (ChannelHandler)new CibOnlineServerBackendHandler(this.profile, promise));
            channel.writeAndFlush(fullHttpRequest).addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            promise.sync();
            if (!promise.isSuccess()) {
                throw new Exception(promise.cause());
            }
            AttributeKey ak = AttributeKey.valueOf("RESPONSE_CONTENT_KEY");
            response = (String)channel.attr(ak).get();
            log.info("\u5ba2\u6237\u7aef\u8bf7\u6c42\u62a5\u6587[\r\n" + logContent + "\r\n], \u94f6\u884c\u7aef\u54cd\u5e94\u62a5\u6587[\r\n" + response + "\r\n]");
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u7aef\u8bf7\u6c42\u62a5\u6587\r\n" + logContent + "\r\n,\u53d1\u751f\u9519\u8bef.\r\nerror:" + e.getMessage());
            throw e;
        }
        finally {
            group.shutdownGracefully();
        }
        return response;
    }

    @Override
    public String postData(String content) throws Exception {
        String responseBody;
        log.info("dcfirmsdk version: 2.3");
        if (StringUtils.isEmpty(content)) {
            throw new Exception("Request content can not empty or null.");
        }
        String logContent = content.replaceAll("<USERPASS>\\S*</USERPASS>", "<USERPASS>******</USERPASS>");
        try (CloseableHttpClient httpclient = HttpClients.custom().setMaxConnTotal(10).build();){
            RequestConfig ex = RequestConfig.custom().setSocketTimeout(this.profile.getTimeOut() * 1000).setConnectTimeout(this.profile.getTimeOut() * 1000).build();
            HttpPost httpPost = new HttpPost(this.profile.getServiceUrl());
            httpPost.setConfig(ex);
            StringEntity stringEntity = new StringEntity(content, Consts.UTF_8);
            stringEntity.setContentType("application/x-www-form-urlencoded");
            httpPost.setEntity(stringEntity);
            CloseableHttpResponse response = httpclient.execute(httpPost);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() >= 300) {
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            HttpEntity entity = response.getEntity();
            responseBody = EntityUtils.toString(entity);
            log.info("\u5ba2\u6237\u7aef\u8bf7\u6c42\u62a5\u6587[\r\n" + logContent + "\r\n], \u94f6\u884c\u7aef\u54cd\u5e94\u62a5\u6587[\r\n" + responseBody + "\r\n]");
            EntityUtils.consume(entity);
        }
        return responseBody;
    }

    private static class EasyTrustManager
    implements X509TrustManager {
        private EasyTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

