/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.handler;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import netbank.firm.base.Util;
import netbank.firm.exception.DcfirmException;
import netbank.firm.model.SysExpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionCaughtHandler
extends ChannelDuplexHandler {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.LOG.error("ExceptionCaughtHandler exceptionCaught:", cause);
        SysExpMessage sysExpMessage = new SysExpMessage();
        sysExpMessage.setErrMsg(cause.getMessage());
        if (cause instanceof DcfirmException) {
            sysExpMessage.setErrCode(((DcfirmException)cause).getErrCode());
        }
        ctx.writeAndFlush(sysExpMessage).addListener(ChannelFutureListener.CLOSE);
        Util.printSysErrorLog(cause.getMessage());
    }
}

