/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.util.AttributeKey;
import java.nio.charset.Charset;
import netbank.firm.config.CibProfile;
import netbank.firm.handler.DcfirmChannelPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CibOnlineServerBackendHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static Logger log = LoggerFactory.getLogger(CibOnlineServerBackendHandler.class);
    private CibProfile profile;
    private DcfirmChannelPromise promise;

    public CibOnlineServerBackendHandler(CibProfile profile, DcfirmChannelPromise promise) {
        this.profile = profile;
        this.promise = promise;
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) {
        ByteBuf content = msg.content();
        byte[] cont = new byte[content.readableBytes()];
        content.readBytes(cont);
        String response = new String(cont, Charset.forName("GBK"));
        log.info("\u8f6c\u53d1\u5668\uff1a\u7ba1\u9053ID[{}],\u8f6c\u53d1\u5668\u8bfb\u53d6\u62a5\u6587[\r\n{}\r\n]", (Object)ctx.channel().id(), (Object)response);
        AttributeKey ak = AttributeKey.valueOf("RESPONSE_CONTENT_KEY");
        ctx.channel().attr(ak).set(response);
        this.promise.setSuccess();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("CibOnlineServerBackendHandler exceptionCaught", cause);
        this.promise.setFailure(cause);
    }
}

