/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.URI;
import netbank.firm.config.CibProfile;
import netbank.firm.dispatch.SslTypeEnum;
import netbank.firm.handler.TransmitterIdleHandler;
import netbank.firm.util.ChannelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CibOnlineBackendInitializer
extends ChannelInitializer<SocketChannel> {
    private static Logger log = LoggerFactory.getLogger(CibOnlineBackendInitializer.class);
    private CibProfile cibProfile;
    private SslTypeEnum sslTypeEnum;

    public CibOnlineBackendInitializer(CibProfile cibProfile, SslTypeEnum sslTypeEnum) {
        this.cibProfile = cibProfile;
        this.sslTypeEnum = sslTypeEnum;
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        URI uri = new URI(this.cibProfile.getServiceUrl());
        pipeline.addLast("ssl", (ChannelHandler)ChannelUtil.getSslHandler(ch, this.sslTypeEnum, this.cibProfile, uri.getHost(), uri.getPort()));
        pipeline.addLast(new HttpResponseDecoder());
        pipeline.addLast(new HttpObjectAggregator(Integer.MAX_VALUE));
        pipeline.addLast(new HttpRequestEncoder());
        pipeline.addLast("writeAndReadIdle", (ChannelHandler)new IdleStateHandler(this.cibProfile.getTimeOut(), this.cibProfile.getTimeOut(), 0));
        pipeline.addLast("dealIdle", (ChannelHandler)new TransmitterIdleHandler());
    }
}

