/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.handler;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.io.File;
import java.io.RandomAccessFile;
import netbank.firm.base.GMUtils;
import netbank.firm.base.GzipUtil;
import netbank.firm.base.MD5Util;
import netbank.firm.model.FileBlockErrorResponse;
import netbank.firm.model.FileBlockResponse;
import netbank.firm.model.FileRequest;
import netbank.firm.model.FileStaticErrorResponse;
import netbank.firm.model.FileStaticRequest;
import netbank.firm.model.FileStaticResponse;
import netbank.firm.model.gmmodel.GmFileBlockErrorResponse;
import netbank.firm.model.gmmodel.GmFileBlockResponse;
import netbank.firm.model.gmmodel.GmFileStaticErrorResponse;
import netbank.firm.model.gmmodel.GmFileStaticRequest;
import netbank.firm.model.gmmodel.GmFileStaticResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.org.apache.commons.lang.StringUtils;

public abstract class AbstractRequestFileHandler4SDK
extends SimpleChannelInboundHandler<FileRequest<?>> {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected File recvFile;
    protected RandomAccessFile fos;
    protected int blockNums;
    protected int lastBlockSize;
    protected int blockId;
    protected String path;
    protected Boolean compress = new Boolean(true);
    protected String fileMd;
    private ChannelPromise promise;

    protected abstract void successHandler(String var1);

    protected abstract void failureHandler(String var1);

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FileRequest<?> msg) throws Exception {
        this.LOG.info("\u901a\u9053id\uff1a" + ctx.channel().id() + ",\u8bf7\u6c42\u7c7b\u578b\uff1a" + (Object)((Object)msg.getFileRequestType()));
        switch (msg.getFileRequestType()) {
            case UPLOAD: {
                break;
            }
            case STATIC: {
                FileStaticRequest fsre = (FileStaticRequest)msg;
                String fileId = fsre.getFileId();
                String fileName = fsre.getFileName();
                int startBlockId = fsre.getStartBlockId();
                this.recvFile = StringUtils.isBlank(fileId) ? new File(this.path + "/" + fileName) : new File(this.path + "/" + fileId + "_" + fileName);
                AttributeKey ak = AttributeKey.valueOf("recvFile");
                ctx.channel().attr(ak).set(this.recvFile.getAbsolutePath());
                try {
                    if (startBlockId > 1) {
                        if (!this.recvFile.exists()) {
                            throw new Exception("\u65ad\u70b9\u7eed\u4f20\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
                        }
                        int filelen = (int)this.recvFile.length();
                        if (filelen < fsre.getBlockSize() * (fsre.getStartBlockId() - 1)) {
                            throw new Exception("\u6587\u4ef6\u5757\u4f4d\u7f6e\u4e0d\u5bf9");
                        }
                    }
                    this.fos = new RandomAccessFile(this.recvFile, "rw");
                    this.fos.seek(fsre.getBlockSize() * (fsre.getStartBlockId() - 1));
                    this.blockId = fsre.getStartBlockId();
                    this.blockNums = fsre.getFileLength() / fsre.getBlockSize() + 1;
                    this.lastBlockSize = fsre.getFileLength() % fsre.getBlockSize();
                    if (this.lastBlockSize == 0 && this.blockNums != 1) {
                        --this.blockNums;
                        this.lastBlockSize = fsre.getBlockSize();
                    }
                    this.compress = fsre.getCompress();
                    this.fileMd = fsre.getFileMd();
                    FileStaticResponse fsr = new FileStaticResponse("ok");
                    this.writeAndFlush(ctx, fsr);
                }
                catch (Exception e) {
                    this.LOG.error("\u8bf7\u6c42\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38:", e);
                    FileStaticErrorResponse fsr = new FileStaticErrorResponse(e.getMessage());
                    this.writeAndFlush(ctx, fsr);
                    ctx.close();
                    if (this.promise != null) {
                        this.promise.setFailure(e);
                    }
                    this.failureHandler(e.getMessage());
                }
                break;
            }
            case DATA: {
                try {
                    if (this.blockNums > 0) {
                        this.LOG.debug("\u6536\u5230\u6587\u4ef6\u5757:[" + this.blockId + "]");
                        this.fos.write(msg.tobytes());
                        --this.blockNums;
                        ++this.blockId;
                        if (this.blockNums == 0) {
                            String md5 = MD5Util.md5Digest(this.recvFile);
                            if (!this.fileMd.equals(md5)) {
                                FileBlockErrorResponse frr = new FileBlockErrorResponse();
                                this.writeAndFlush(ctx, frr);
                                String errMessage = "\u6587\u4ef6\u6458\u8981\u6821\u9a8c\u4e0d\u7b26";
                                this.LOG.error(errMessage);
                                if (this.promise != null) {
                                    this.promise.setFailure(new Exception(errMessage));
                                }
                                this.failureHandler(errMessage);
                                break;
                            }
                            FileBlockResponse frr = new FileBlockResponse();
                            this.writeAndFlush(ctx, frr);
                            this.LOG.info("\u901a\u8fc7\u6587\u4ef6\u6458\u8981\u6821\u9a8c");
                            if (this.promise != null) {
                                this.promise.setSuccess();
                            }
                            String targetFile = null;
                            if (this.compress.booleanValue()) {
                                GzipUtil.gunzip(this.recvFile.getAbsolutePath());
                                targetFile = this.recvFile.getAbsolutePath();
                                if (targetFile.substring(0, targetFile.indexOf(".gz")) != null) {
                                    targetFile = targetFile.substring(0, targetFile.indexOf(".gz"));
                                }
                                if (this.recvFile.exists()) {
                                    this.recvFile.delete();
                                }
                            }
                            this.successHandler(targetFile);
                            if (this.fos != null) {
                                this.fos.close();
                            }
                            ctx.close();
                            break;
                        }
                        FileBlockResponse frr = new FileBlockResponse();
                        this.writeAndFlush(ctx, frr);
                        break;
                    }
                    if (this.fos != null) {
                        this.fos.close();
                    }
                    ctx.close();
                    if (this.promise != null) {
                        this.promise.setSuccess();
                    }
                    this.successHandler(this.recvFile.getAbsolutePath());
                }
                catch (Exception e) {
                    FileBlockErrorResponse frr = new FileBlockErrorResponse();
                    this.writeAndFlush(ctx, frr);
                    if (this.fos != null) {
                        this.fos.close();
                    }
                    ctx.close();
                    if (this.promise != null) {
                        this.promise.setFailure(e);
                    }
                    this.failureHandler(e.getMessage());
                }
                break;
            }
            case GM_UPLOAD: {
                break;
            }
            case GM_STATIC: {
                GmFileStaticRequest fsre = (GmFileStaticRequest)msg;
                String fileId = fsre.getFileId();
                String fileName = fsre.getFileName();
                int startBlockId = fsre.getStartBlockId();
                this.recvFile = StringUtils.isBlank(fileId) ? new File(this.path + "/" + fileName) : new File(this.path + "/" + fileId + "_" + fileName);
                AttributeKey ak = AttributeKey.valueOf("recvFile");
                ctx.channel().attr(ak).set(this.recvFile.getAbsolutePath());
                try {
                    if (startBlockId > 1) {
                        if (!this.recvFile.exists()) {
                            throw new Exception("\u65ad\u70b9\u7eed\u4f20\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
                        }
                        int filelen = (int)this.recvFile.length();
                        if (filelen < fsre.getBlockSize() * (fsre.getStartBlockId() - 1)) {
                            throw new Exception("\u6587\u4ef6\u5757\u4f4d\u7f6e\u4e0d\u5bf9");
                        }
                    }
                    this.fos = new RandomAccessFile(this.recvFile, "rw");
                    this.fos.seek(fsre.getBlockSize() * (fsre.getStartBlockId() - 1));
                    this.blockId = fsre.getStartBlockId();
                    this.blockNums = fsre.getFileLength() / fsre.getBlockSize() + 1;
                    this.lastBlockSize = fsre.getFileLength() % fsre.getBlockSize();
                    if (this.lastBlockSize == 0 && this.blockNums != 1) {
                        --this.blockNums;
                        this.lastBlockSize = fsre.getBlockSize();
                    }
                    this.compress = fsre.getCompress();
                    this.fileMd = fsre.getFileMd();
                    GmFileStaticResponse fsr = new GmFileStaticResponse("ok");
                    this.writeAndFlush(ctx, fsr);
                }
                catch (Exception e) {
                    this.LOG.error("\u8bf7\u6c42\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38:", e);
                    GmFileStaticErrorResponse fsr = new GmFileStaticErrorResponse(e.getMessage());
                    this.writeAndFlush(ctx, fsr);
                    ctx.close();
                    if (this.promise != null) {
                        this.promise.setFailure(e);
                    }
                    this.failureHandler(e.getMessage());
                }
                break;
            }
            case GM_DATA: {
                try {
                    if (this.blockNums > 0) {
                        this.LOG.debug("\u6536\u5230\u6587\u4ef6\u5757:[" + this.blockId + "]");
                        this.fos.write(msg.tobytes());
                        --this.blockNums;
                        ++this.blockId;
                        if (this.blockNums == 0) {
                            String md5 = GMUtils.sm3DigestGen(this.recvFile);
                            if (!this.fileMd.equals(md5)) {
                                GmFileBlockErrorResponse frr = new GmFileBlockErrorResponse();
                                this.writeAndFlush(ctx, frr);
                                String errMessage = "\u6587\u4ef6\u6458\u8981\u6821\u9a8c\u4e0d\u7b26";
                                this.LOG.error(errMessage);
                                if (this.promise != null) {
                                    this.promise.setFailure(new Exception(errMessage));
                                }
                                this.failureHandler(errMessage);
                                break;
                            }
                            GmFileStaticResponse frr = new GmFileStaticResponse();
                            this.writeAndFlush(ctx, frr);
                            this.LOG.info("\u901a\u8fc7\u6587\u4ef6\u6458\u8981\u6821\u9a8c");
                            if (this.promise != null) {
                                this.promise.setSuccess();
                            }
                            String targetFile = null;
                            if (this.compress.booleanValue()) {
                                GzipUtil.gunzip(this.recvFile.getAbsolutePath());
                                targetFile = this.recvFile.getAbsolutePath();
                                if (targetFile.substring(0, targetFile.indexOf(".gz")) != null) {
                                    targetFile = targetFile.substring(0, targetFile.indexOf(".gz"));
                                }
                                if (this.recvFile.exists()) {
                                    this.recvFile.delete();
                                }
                            }
                            this.successHandler(targetFile);
                            if (this.fos != null) {
                                this.fos.close();
                            }
                            ctx.close();
                            break;
                        }
                        GmFileBlockResponse frr = new GmFileBlockResponse();
                        this.writeAndFlush(ctx, frr);
                        break;
                    }
                    if (this.fos != null) {
                        this.fos.close();
                    }
                    ctx.close();
                    if (this.promise != null) {
                        this.promise.setSuccess();
                    }
                    this.successHandler(this.recvFile.getAbsolutePath());
                }
                catch (Exception e) {
                    GmFileBlockErrorResponse frr = new GmFileBlockErrorResponse();
                    this.writeAndFlush(ctx, frr);
                    if (this.fos != null) {
                        this.fos.close();
                    }
                    ctx.close();
                    if (this.promise != null) {
                        this.promise.setFailure(e);
                    }
                    this.failureHandler(e.getMessage());
                }
                break;
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.fos != null) {
            this.fos.close();
        }
        ctx.close();
        this.LOG.error("[\u901a\u9053id\uff1a" + ctx.channel().id() + "]\uff0c" + cause.getMessage(), cause);
        if (this.promise != null) {
            this.promise.setFailure(cause);
        }
        this.failureHandler(cause.getMessage());
    }

    private void writeAndFlush(ChannelHandlerContext ctx, Object obj) {
        ChannelFuture f = ctx.writeAndFlush(obj);
        f.addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setPromise(ChannelPromise promise) {
        this.promise = promise;
    }
}

