/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.gm.protocol;

import java.util.concurrent.ConcurrentHashMap;
import netbank.firm.gm.annotation.MsgType;
import netbank.firm.gm.constant.HsmCommandCode;
import netbank.firm.gm.protocol.resp.ErrorMessageResp;
import netbank.firm.gm.protocol.resp.ExportSM2KeypairResp;
import netbank.firm.gm.protocol.resp.GenSM2KeypairResp;
import netbank.firm.gm.protocol.resp.QuerySM2KeypairIndexesResp;
import netbank.firm.gm.protocol.resp.ResponseHead;
import netbank.firm.gm.protocol.resp.SM2DecryptResp;
import netbank.firm.gm.protocol.resp.SM2EncryptResp;
import netbank.firm.gm.protocol.resp.SM2ToSM4Resp;
import netbank.firm.gm.protocol.resp.SM3GetResultResp;
import netbank.firm.gm.protocol.resp.SM3InitialResp;
import netbank.firm.gm.protocol.resp.SM3UpdateResp;
import netbank.firm.gm.protocol.resp.SM4DecryptResp;
import netbank.firm.gm.protocol.resp.SM4EncryptResp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsmMessageMap {
    private static final ConcurrentHashMap<HsmCommandCode, Class<?>> msgMap = new ConcurrentHashMap();
    private static HsmMessageMap instance;

    private HsmMessageMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HsmMessageMap getInstance() {
        if (null != instance) return instance;
        Class<HsmMessageMap> clazz = HsmMessageMap.class;
        synchronized (HsmMessageMap.class) {
            if (instance != null) return instance;
            instance = new HsmMessageMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void registerMsg(Class ... classes) {
        for (Class clazz : classes) {
            MsgType msgType = clazz.getAnnotation(MsgType.class);
            msgMap.put(msgType.commandCode(), clazz);
        }
    }

    public static void registerSpMsg(HsmCommandCode ... hsmCommandCodes) {
        for (HsmCommandCode code : hsmCommandCodes) {
            msgMap.put(code, ResponseHead.class);
        }
    }

    public ConcurrentHashMap<HsmCommandCode, Class<?>> getMsgMap() {
        return msgMap;
    }

    static {
        HsmMessageMap.registerMsg(ResponseHead.class, ErrorMessageResp.class, ExportSM2KeypairResp.class, GenSM2KeypairResp.class, QuerySM2KeypairIndexesResp.class, SM2DecryptResp.class, SM2EncryptResp.class, SM2ToSM4Resp.class, SM4DecryptResp.class, SM4EncryptResp.class, SM3InitialResp.class, SM3GetResultResp.class, SM3UpdateResp.class);
        HsmMessageMap.registerSpMsg(HsmCommandCode.TEST_HSM, HsmCommandCode.IMPORT_SM2_KEYPAIR);
    }
}

