/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.gm.protocol;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import netbank.firm.exception.DcfirmRTException;
import netbank.firm.gm.annotation.ColumnProperty;
import netbank.firm.gm.constant.ColumnType;
import netbank.firm.gm.constant.HsmCommandCode;
import netbank.firm.gm.protocol.HsmMessageMap;
import netbank.firm.gm.protocol.resp.ErrorMessageResp;
import netbank.firm.gm.protocol.resp.ResponseHead;
import netbank.firm.gm.utils.ConvertUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsmMessage {
    public static final Log LOG = LogFactory.getLog(HsmMessage.class);
    public static final Integer MSG_MAX_SIZE = 65536;
    public static final Integer MAX_SIGNED_SHORT = 32768;
    public static final Integer MAX_UNSIGNED_SHORT = 65536;
    private HsmCommandCode hsmCommandCode;

    public HsmMessage(HsmCommandCode hsmCommandCode) {
        this.hsmCommandCode = hsmCommandCode;
    }

    public byte[] serialize() {
        Field[] fileds;
        ByteBuffer byteBuffer = ByteBuffer.allocate(MSG_MAX_SIZE);
        for (Field field : fileds = this.getClass().getDeclaredFields()) {
            ColumnProperty columnProperty = field.getAnnotation(ColumnProperty.class);
            Object object = null;
            try {
                field.setAccessible(true);
                object = field.get(this);
                ColumnType type = columnProperty.type();
                type.serialize(byteBuffer, object);
            }
            catch (IllegalAccessException ie) {
                LOG.error("HSM\u786c\u4ef6\u52a0\u5bc6\u673a\u6d88\u606f\u5e8f\u5217\u5316\u5931\u8d25, hsmCommandCode = " + this.getHexCommandCode() + ", field = " + field + ", obj = " + object + ", columnProperty = " + columnProperty);
                throw new DcfirmRTException("14103", "HSM\u786c\u4ef6\u52a0\u5bc6\u673a\u6d88\u606f\u5e8f\u5217\u5316\u5931\u8d25", ie);
            }
        }
        byte[] msgLenBytes = new byte[2];
        Integer msgLength = byteBuffer.position();
        if (msgLength < MAX_SIGNED_SHORT) {
            Short len = Integer.valueOf(msgLength).shortValue();
            msgLenBytes = ConvertUtil.shortToByte(len);
        } else if (msgLength >= MAX_SIGNED_SHORT && msgLength < MAX_UNSIGNED_SHORT) {
            msgLenBytes = ConvertUtil.unsignedShortToByte(msgLength);
        } else {
            throw new DcfirmRTException("14103", "\u6d88\u606f\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236");
        }
        byte[] msgPack = new byte[2 + msgLength];
        System.arraycopy(msgLenBytes, 0, msgPack, 0, 2);
        System.arraycopy(byteBuffer.array(), 0, msgPack, 2, msgLength);
        return msgPack;
    }

    public static final Boolean success(ByteBuffer byteBuffer) {
        return HsmMessage.deserializeHead(byteBuffer);
    }

    public static final ErrorMessageResp deserializeError(ByteBuffer byteBuffer) {
        ErrorMessageResp errorMsg = (ErrorMessageResp)HsmMessage.getMsg(byteBuffer, ErrorMessageResp.class);
        return errorMsg;
    }

    public static final Boolean deserializeHead(ByteBuffer byteBuffer) {
        HsmMessage hsmMessage = HsmMessage.getMsg(byteBuffer, ResponseHead.class);
        if (((ResponseHead)hsmMessage).getMsgLength() == 0) {
            throw new DcfirmRTException("14106", "HSM\u786c\u4ef6\u52a0\u5bc6\u673a\u6d88\u606f\u4f53\u4e3a\u7a7a");
        }
        return ((ResponseHead)hsmMessage).getRetCode() == 65;
    }

    public static final HsmMessage deserializeMsg(ByteBuffer byteBuffer, HsmCommandCode hsmCommandCode) {
        Class<?> clazz = HsmMessageMap.getInstance().getMsgMap().get((Object)hsmCommandCode);
        if (clazz == null) {
            LOG.error("HSM\u786c\u4ef6\u52a0\u5bc6\u673a\u6d88\u606f\u89e3\u6790\u672a\u627e\u5230\u6d88\u606f\u7c7b\u578b, hsmCommandCode = " + Hex.encode(hsmCommandCode.getCode()));
            throw new DcfirmRTException("14104", "HSM\u786c\u4ef6\u52a0\u5bc6\u673a\u6d88\u606f\u89e3\u6790\u5931\u8d25");
        }
        HsmMessage hsmMessage = HsmMessage.getMsg(byteBuffer, clazz);
        return hsmMessage;
    }

    public String getHexCommandCode() {
        if (null != this.hsmCommandCode) {
            return new String(Hex.encode(this.hsmCommandCode.getCode()));
        }
        return null;
    }

    public HsmCommandCode getHsmCommandCode() {
        return this.hsmCommandCode;
    }

    private static final HsmMessage getMsg(ByteBuffer byteBuffer, Class<?> clazz) {
        Field[] fields;
        HsmMessage hsmMessage = null;
        try {
            hsmMessage = (HsmMessage)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            LOG.error("HSM\u786c\u4ef6\u52a0\u5bc6\u673a\u6d88\u606f\u53cd\u5e8f\u5217\u521b\u5efa\u5b9e\u4f8b\u5bf9\u8c61\u5931\u8d25, class = " + clazz);
            throw new DcfirmRTException("14104", "HSM\u786c\u4ef6\u52a0\u5bc6\u673a\u6d88\u606f\u89e3\u6790\u5931\u8d25", e);
        }
        catch (InstantiationException e) {
            LOG.error("HSM\u786c\u4ef6\u52a0\u5bc6\u673a\u6d88\u606f\u53cd\u5e8f\u5217\u521b\u5efa\u5b9e\u4f8b\u5bf9\u8c61\u5931\u8d25, class = " + clazz);
            throw new DcfirmRTException("14104", "HSM\u786c\u4ef6\u52a0\u5bc6\u673a\u6d88\u606f\u89e3\u6790\u5931\u8d25", e);
        }
        if (hsmMessage instanceof ResponseHead) {
            byteBuffer.rewind();
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            ColumnProperty columnProperty = field.getAnnotation(ColumnProperty.class);
            if (columnProperty == null) continue;
            field.setAccessible(true);
            try {
                ColumnType columnType = columnProperty.type();
                field.set(hsmMessage, columnType.deserialize(byteBuffer));
            }
            catch (IllegalAccessException ie) {
                LOG.error("HSM\u786c\u4ef6\u52a0\u5bc6\u673a\u6d88\u606f\u53cd\u5e8f\u5217\u5316\u5931\u8d25, field = " + field + ", columnProperties = " + columnProperty);
                throw new DcfirmRTException("14104", "HSM\u786c\u4ef6\u52a0\u5bc6\u673a\u6d88\u606f\u89e3\u6790\u5931\u8d25", ie);
            }
        }
        return hsmMessage;
    }
}

