/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.encoder;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import netbank.firm.base.CFCASignature;
import netbank.firm.base.GMUtils;
import netbank.firm.base.MD5Util;
import netbank.firm.config.CibProfile;
import netbank.firm.encoder.DcfirmMessageToMessageEncoder;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.model.Message;
import netbank.firm.model.MessageHead;
import netbank.firm.model.MessageType;
import netbank.firm.model.gmmodel.GmMessageHead;
import netbank.firm.model.gmmodel.GmMessageHeadV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDigestEncoder
extends DcfirmMessageToMessageEncoder<Message> {
    private CibProfile profile;
    protected final Logger macLog = LoggerFactory.getLogger("filemac.out");

    public MessageDigestEncoder(CibProfile profile) {
        this.profile = profile;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        try {
            if (msg.getMessageType() == MessageType.MESSAGE) {
                if (msg.getBody() != null) {
                    this.LOG.debug("\u53c2\u4e0e\u8ba1\u7b97\u7684\u6d88\u606f\uff1a[" + new String(msg.getBody(), "GBK") + "]");
                    String md5 = null;
                    if (msg.getHead() instanceof MessageHead) {
                        this.LOG.debug("\u3010\u8ba1\u7b97MD5\u3011\u91c7\u7528MD5\u7b97\u6cd5\u8ba1\u7b97\u6d88\u606f\u6458\u8981......");
                        md5 = MD5Util.md5Digest(msg.getBody());
                        MessageHead mh = (MessageHead)msg.getHead();
                        mh.setMd(md5);
                        this.macLog.info("\u7b97\u51fa\u6d88\u606f\u6458\u8981MD5\uff1a[" + md5 + "]");
                    } else if (msg.getHead() instanceof GmMessageHead) {
                        this.LOG.debug("\u3010\u8ba1\u7b97SM3\u3011\u91c7\u7528\u56fd\u5bc6SM3\u7b97\u6cd5\u8ba1\u7b97\u6d88\u606f\u6458\u8981......");
                        md5 = GMUtils.sm3DigestGen(msg.getBody());
                        GmMessageHead mh = (GmMessageHead)msg.getHead();
                        mh.setMd(md5);
                        this.macLog.info("\u7b97\u51fa\u6d88\u606f\u6458\u8981SM3\uff1a[" + md5 + "]");
                    } else if (msg.getHead() instanceof GmMessageHeadV2) {
                        this.LOG.debug("\u3010\u8ba1\u7b97SM3\u3011\u91c7\u7528\u56fd\u5bc6SM3\u7b97\u6cd5\u8ba1\u7b97\u6d88\u606f\u6458\u8981......");
                        md5 = GMUtils.sm3DigestGen(msg.getBody());
                        GmMessageHeadV2 mh = (GmMessageHeadV2)msg.getHead();
                        mh.setMd(md5);
                        if (null != this.profile) {
                            this.LOG.debug("\u3010\u8ba1\u7b97SM3\u7684\u7b7e\u540d\u3011\u91c7\u7528\u6570\u5b57\u8bc1\u4e66\u8ba1\u7b97\u7b7e\u540d......");
                            CFCASignature signatureUtil = new CFCASignature();
                            signatureUtil.setProfile(this.profile);
                            String sm3Sign = signatureUtil.signature(md5);
                            mh.setSm3Signature(sm3Sign);
                            mh.setSm3SignLength(sm3Sign.getBytes().length);
                        }
                        this.macLog.info("\u7b97\u51fa\u6d88\u606f\u6458\u8981SM3\uff1a[" + md5 + "]");
                    }
                    this.LOG.debug("\u7b97\u51fa\u6d88\u606f\u6458\u8981\uff1a[" + md5 + "]");
                } else {
                    this.LOG.debug("\u65e0\u9700\u6458\u8981\u5904\u7406");
                }
            }
            out.add(msg);
        }
        catch (Exception e) {
            throw new DcfirmException(ExceptionCode.U114, (Throwable)e);
        }
    }
}

