/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.encoder;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import netbank.firm.base.AESUtils;
import netbank.firm.encoder.DcfirmMessageToMessageEncoder;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.model.Message;
import netbank.firm.model.MessageHead;
import netbank.firm.model.MessageType;
import netbank.firm.model.gmmodel.GmMessageHead;
import netbank.firm.model.gmmodel.GmMessageHeadV2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptEncoder
extends DcfirmMessageToMessageEncoder<Message> {
    @Override
    protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        try {
            if (msg.getMessageType() == MessageType.MESSAGE) {
                boolean isEncrypt = false;
                if (msg.getHead() instanceof MessageHead) {
                    isEncrypt = ((MessageHead)msg.getHead()).getEncrypt();
                } else if (msg.getHead() instanceof GmMessageHead) {
                    isEncrypt = ((GmMessageHead)msg.getHead()).getEncrypt();
                } else if (msg.getHead() instanceof GmMessageHeadV2) {
                    isEncrypt = ((GmMessageHeadV2)msg.getHead()).getEncrypt();
                }
                if (isEncrypt) {
                    if (msg.getHead() instanceof MessageHead) {
                        MessageHead mh = (MessageHead)msg.getHead();
                        this.LOG.debug("\u52a0\u5bc6\u5904\u7406" + mh.getKey());
                        msg.setBody(AESUtils.encrypt(mh.getKey().getBytes(), msg.getBody()));
                    }
                    msg.getHead().setLength(msg.getBody().length);
                } else {
                    this.LOG.debug("\u65e0\u9700\u52a0\u5bc6\u5904\u7406");
                }
            }
            out.add(msg);
        }
        catch (Exception e) {
            throw new DcfirmException(ExceptionCode.U109, (Throwable)e);
        }
    }
}

