/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.encoder;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import netbank.firm.base.CompressionUtil;
import netbank.firm.encoder.DcfirmMessageToMessageEncoder;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.model.Message;
import netbank.firm.model.MessageHead;
import netbank.firm.model.MessageType;
import netbank.firm.model.gmmodel.GmMessageHead;
import netbank.firm.model.gmmodel.GmMessageHeadV2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompressEncoder
extends DcfirmMessageToMessageEncoder<Message> {
    @Override
    protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        try {
            if (msg.getMessageType() == MessageType.MESSAGE) {
                boolean isCompress = false;
                if (msg.getHead() instanceof MessageHead) {
                    isCompress = ((MessageHead)msg.getHead()).getCompress();
                } else if (msg.getHead() instanceof GmMessageHead) {
                    isCompress = ((GmMessageHead)msg.getHead()).getCompress();
                } else if (msg.getHead() instanceof GmMessageHeadV2) {
                    isCompress = ((GmMessageHeadV2)msg.getHead()).getCompress();
                }
                if (isCompress) {
                    this.LOG.debug("\u538b\u7f29\u5904\u7406");
                    byte[] body = msg.getBody();
                    body = CompressionUtil.compress(body);
                    msg.setBody(body);
                    msg.getHead().setLength(body.length);
                } else {
                    this.LOG.debug("\u65e0\u9700\u538b\u7f29\u5904\u7406");
                }
            }
            out.add(msg);
        }
        catch (Exception e) {
            throw new DcfirmException(ExceptionCode.U105, (Throwable)e);
        }
    }
}

