/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.dispatch;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.URI;
import netbank.firm.config.CibProfile;
import netbank.firm.dispatch.SslTypeEnum;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.handler.CibOnlineBackendInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CibDispatcher {
    private static Logger log = LoggerFactory.getLogger(CibDispatcher.class);
    public static final String SSL_FUTURE_KEY = "SSL_FUTURE_KEY";
    public static final String RESPONSE_CONTENT_KEY = "RESPONSE_CONTENT_KEY";

    public static Channel connectRemoteServer(NioEventLoopGroup group, CibProfile profile) throws Exception {
        return CibDispatcher.connectRemoteServer(group, profile, SslTypeEnum.SM);
    }

    private static Channel connectRemoteServer(NioEventLoopGroup group, CibProfile profile, SslTypeEnum sslTypeEnum) throws Exception {
        Future sslFuture;
        ChannelFuture connectFuture;
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).handler(new CibOnlineBackendInitializer(profile, sslTypeEnum))).option(ChannelOption.AUTO_READ, true);
        URI uri = new URI(profile.getServiceUrl());
        int port = uri.getPort();
        if (port == -1 && "https".equals(uri.getScheme())) {
            port = 443;
        }
        if (!(connectFuture = bootstrap.connect(new InetSocketAddress(uri.getHost(), port)).sync()).isSuccess()) {
            log.error("\u8fde\u63a5\u8fdc\u7aef\u670d\u52a1\u5668\u5931\u8d25\uff1a", connectFuture.cause());
            throw new DcfirmException(ExceptionCode.C001);
        }
        Channel outboundChannel = connectFuture.channel();
        log.info("\u8fde\u63a5[{}]\u6210\u529f", (Object)profile.getServiceUrl());
        log.info("\u5efa\u7acbssl [{}] \u901a\u9053\u4e2d\u2026\u2026", (Object)sslTypeEnum);
        AttributeKey sslFutureKey = AttributeKey.valueOf(SSL_FUTURE_KEY);
        Attribute sslFutureValue = outboundChannel.attr(sslFutureKey);
        Future future = sslFuture = sslFutureValue == null ? null : (Future)sslFutureValue.get();
        if (null == sslFuture) {
            throw new DcfirmException(ExceptionCode.S004);
        }
        try {
            sslFuture.sync();
        }
        catch (Exception e) {
            log.error("ssl [{}] \u901a\u9053\u5efa\u7acb\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Object)sslTypeEnum, (Object)e);
            if (SslTypeEnum.SM.equals((Object)sslTypeEnum)) {
                log.debug("ssl\u901a\u9053\u5efa\u7acb\u5931\u8d25\uff0c\u964d\u7ea7\u6210\u56fd\u9645\u901a\u9053");
                return CibDispatcher.connectRemoteServer(group, profile, SslTypeEnum.INT);
            }
            throw new DcfirmException(ExceptionCode.C001, (Throwable)e);
        }
        if (!sslFuture.isSuccess()) {
            outboundChannel.close();
            log.warn("ssl [{}] \u901a\u9053\u5efa\u7acb\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Object)sslTypeEnum, (Object)sslFuture.cause());
            if (SslTypeEnum.SM.equals((Object)sslTypeEnum)) {
                log.debug("ssl\u901a\u9053\u5efa\u7acb\u5931\u8d25\uff0c\u964d\u7ea7\u6210\u56fd\u9645\u901a\u9053");
                return CibDispatcher.connectRemoteServer(group, profile, SslTypeEnum.INT);
            }
            throw new DcfirmException(ExceptionCode.C001, sslFuture.cause());
        }
        log.info("\u5efa\u7acbssl [{}] \u901a\u9053 \u6210\u529f", (Object)sslTypeEnum);
        return outboundChannel;
    }
}

