/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import netbank.firm.config.HsmConfig;
import netbank.firm.exception.DcfirmException;
import shade.org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertUtil {
    private static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean stringToBool(String str) {
        if ("1".equals(str)) {
            return true;
        }
        if ("0".equals(str)) {
            return false;
        }
        return Boolean.parseBoolean(str);
    }

    public static String boolToString(boolean bool) {
        if (bool) {
            return "1";
        }
        return "0";
    }

    public static int charToHex(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("\u4e0d\u7b26\u5408\u683c\u5f0f\u768416\u8fdb\u5236\u5b57\u7b26: " + c);
    }

    public static String bytesToHexStr(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(hexChar[(bytes[i] & 0xF0) >>> 4]);
            sb.append(hexChar[bytes[i] & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] hexStrToBytes(String s) {
        int stringLength = s.length();
        if ((stringLength & 1) != 0) {
            throw new IllegalArgumentException("\u5f85\u8f6c\u6362\u7684\u5b57\u7b26\u4e32\u957f\u5ea6\u5fc5\u9700\u4e3a\u5076\u6570\u3002");
        }
        byte[] b = new byte[stringLength / 2];
        int i = 0;
        int j = 0;
        while (i < stringLength) {
            int high = ConvertUtil.charToHex(s.charAt(i));
            int low = ConvertUtil.charToHex(s.charAt(i + 1));
            b[j] = (byte)(high << 4 | low);
            i += 2;
            ++j;
        }
        return b;
    }

    public static String dateToString(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static Date stringToDate(String dateStr, String format) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.parse(dateStr);
    }

    public static Date linkDateAndTime(Date dateSrc, Date timeSrc) {
        Calendar date = Calendar.getInstance();
        Calendar time = Calendar.getInstance();
        date.setTime(dateSrc);
        time.setTime(timeSrc);
        date.set(11, time.get(11));
        date.set(12, time.get(12));
        date.set(13, time.get(13));
        date.set(14, time.get(14));
        return date.getTime();
    }

    public static BigDecimal toAmtScale(BigDecimal amt) {
        return amt.setScale(2, RoundingMode.HALF_UP);
    }

    public static String toUnicode(String zhStr) {
        StringBuffer unicode = new StringBuffer();
        for (int i = 0; i < zhStr.length(); ++i) {
            char c = zhStr.charAt(i);
            unicode.append("\\u" + Integer.toHexString(c));
        }
        return unicode.toString();
    }

    public static String tozhCN(String unicode) {
        StringBuffer gbk = new StringBuffer();
        String[] hex = unicode.split("\\\\u");
        for (int i = 1; i < hex.length; ++i) {
            int data = Integer.parseInt(hex[i], 16);
            gbk.append((char)data);
        }
        return gbk.toString();
    }

    public static StringBuffer decodeUnicode(String dataStr) {
        StringBuffer buffer = new StringBuffer();
        String tempStr = "";
        String operStr = dataStr;
        if (operStr != null && operStr.indexOf("\\u") == -1) {
            return buffer.append(operStr);
        }
        if (operStr != null && !operStr.equals("") && !operStr.startsWith("\\u")) {
            tempStr = operStr.substring(0, operStr.indexOf("\\u"));
            operStr = operStr.substring(operStr.indexOf("\\u"), operStr.length());
        }
        buffer.append(tempStr);
        while (operStr != null && !operStr.equals("") && operStr.startsWith("\\u")) {
            tempStr = operStr.substring(0, 6);
            operStr = operStr.substring(6, operStr.length());
            String charStr = "";
            charStr = tempStr.substring(2, tempStr.length());
            char letter = (char)Integer.parseInt(charStr, 16);
            buffer.append(new Character(letter).toString());
            if (operStr.indexOf("\\u") == -1) {
                buffer.append(operStr);
                continue;
            }
            tempStr = operStr.substring(0, operStr.indexOf("\\u"));
            operStr = operStr.substring(operStr.indexOf("\\u"), operStr.length());
            buffer.append(tempStr);
        }
        return buffer;
    }

    public static String joinAppointParams(Map<String, String> map, String innerSpliter, String outerSpliter, boolean notNull, String ... args) {
        StringBuilder sb = new StringBuilder();
        String value = "";
        for (String key : args) {
            value = map.get(key);
            if (notNull && (value == null || "".equals(value.trim()))) continue;
            if (sb.length() != 0) {
                sb.append(outerSpliter);
            }
            sb.append(key);
            sb.append(innerSpliter);
            sb.append(value);
        }
        if (sb.length() > 255) {
            sb.setLength(255);
        }
        return sb.toString();
    }

    public static Map<String, String> parseStrToHashMap(String str) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (str != null && !"".equals(str.trim()) && str.startsWith("{") && str.endsWith("}")) {
            str = str.substring(1, str.length() - 1);
        }
        String[] array = str.split(",");
        int index = 0;
        String left = null;
        String right = null;
        for (String string : array) {
            index = string.indexOf(58);
            if (index <= 0 || index >= string.length()) continue;
            left = string.substring(0, index);
            if (left.startsWith("\"") && left.endsWith("\"")) {
                left = left.substring(1, left.length() - 1);
            }
            if ((right = string.substring(index + 1)).startsWith("\"") && right.endsWith("\"")) {
                right = right.substring(1, right.length() - 1);
            }
            map.put(left, right);
        }
        return map;
    }

    public static List asList(Object[] a) {
        return a == null ? null : Arrays.asList(a);
    }

    public static String getFixedLengthString(Object field, int fixedLength) {
        char[] chars;
        if (fixedLength < 1) {
            return "";
        }
        if (field == null) {
            return String.format("%-" + fixedLength + "s", " ");
        }
        for (char c : chars = field.toString().toCharArray()) {
            if (!ConvertUtil.isCNChar(c)) continue;
            --fixedLength;
        }
        fixedLength = fixedLength < 1 ? 1 : fixedLength;
        return String.format("%-" + fixedLength + "s", field);
    }

    public static int countChineseChar(String str) {
        int chineseCharNum = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (!ConvertUtil.isCNChar(str.charAt(i))) continue;
            ++chineseCharNum;
        }
        return chineseCharNum;
    }

    private static boolean isCNChar(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static String trimString(String value) {
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        return value.trim();
    }

    public static byte[] intToBytes(int num) {
        byte[] bytes = new byte[]{(byte)(0xFF & num >> 0), (byte)(0xFF & num >> 8), (byte)(0xFF & num >> 16), (byte)(0xFF & num >> 24)};
        return bytes;
    }

    public static int byteToInt(byte[] bytes) {
        int num = 0;
        int temp = (0xFF & bytes[0]) << 0;
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        temp = (0xFF & bytes[2]) << 16;
        num |= temp;
        temp = (0xFF & bytes[3]) << 24;
        return num |= temp;
    }

    public static byte[] byteConvert32Bytes(BigInteger n) {
        byte[] tmpd = null;
        if (n == null) {
            return null;
        }
        if (n.toByteArray().length == 33) {
            tmpd = new byte[32];
            System.arraycopy(n.toByteArray(), 1, tmpd, 0, 32);
        } else if (n.toByteArray().length == 32) {
            tmpd = n.toByteArray();
        } else {
            tmpd = new byte[32];
            for (int i = 0; i < 32 - n.toByteArray().length; ++i) {
                tmpd[i] = 0;
            }
            System.arraycopy(n.toByteArray(), 0, tmpd, 32 - n.toByteArray().length, n.toByteArray().length);
        }
        return tmpd;
    }

    public static byte[] longToBytes(long num) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(0xFFL & num >> i * 8);
        }
        return bytes;
    }

    public static byte[] shortToByte(Short num) {
        byte[] bytes = new byte[2];
        bytes[1] = (byte)(0xFF & num);
        bytes[0] = (byte)(0xFF & num >> 8);
        return bytes;
    }

    public static byte[] IntegerToLengthBytes(Integer num) {
        if (num > 99 || num < 0) {
            throw new IllegalArgumentException("\u5f85\u8f6c\u6362\u7684\u6570\u5b57\u8303\u56f4\u4e0d\u6b63\u786e\u3002");
        }
        byte[] lengthByte = new byte[2];
        Integer high = num / 10 + 48;
        Integer low = num % 10 + 48;
        lengthByte[0] = high.byteValue();
        lengthByte[1] = low.byteValue();
        return lengthByte;
    }

    public static Integer lengthBytesToInteger(byte[] bytes) {
        for (byte b : bytes) {
            if (b <= 57 && b >= 48) continue;
            throw new IllegalArgumentException("\u5f85\u8f6c\u6362\u7684\u6570\u5b57\u8303\u56f4\u4e0d\u6b63\u786e\u3002");
        }
        return (bytes[0] - 48) * 10 + (bytes[1] - 48);
    }

    public static String constructProtocol(String rawPwd) throws DcfirmException {
        if (StringUtils.isEmpty(rawPwd)) {
            throw new DcfirmException("14108", "\u6784\u5efa\u6d88\u606f\u534f\u8bae\u5931\u8d25\uff0c\u5bc6\u7801\u539f\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (rawPwd.length() > HsmConfig.RAWPASS_MAX_LENGTH) {
            throw new DcfirmException("14109", "\u6784\u5efa\u6d88\u606f\u534f\u8bae\u5931\u8d25\uff0c\u5bc6\u7801\u539f\u6587\u8d85\u8fc7120\u4f4d");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[HsmConfig.PROTOCOL_FIX_LENGTH.intValue()]);
        byte[] lengthByte = netbank.firm.gm.utils.ConvertUtil.IntegerToLengthBytes(rawPwd.length());
        byteBuffer.put(lengthByte);
        byteBuffer.put(rawPwd.getBytes());
        Integer padLength = HsmConfig.PROTOCOL_FIX_LENGTH - 2 - rawPwd.length();
        byte[] pad = new byte[padLength.intValue()];
        for (int i = 0; i < padLength; ++i) {
            pad[i] = 97;
        }
        byteBuffer.put(pad);
        return new String(byteBuffer.array());
    }
}

