/*
 * Decompiled with CFR 0.152.
 */
package com.cib.smtools.sm;

import com.cib.smtools.sm.CIBSMTools;
import com.cib.smtools.sm.SM3;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.org.bouncycastle.util.Arrays;
import shaded.org.bouncycastle.util.encoders.Hex;

public class SM4 {
    public static final String NOPADDING = "NOPADDING";
    public static final String PKCS7_PADDING = "PKCS7Padding";
    public static final String PKCS5_PADDING = "PKCS5Padding";
    private static String ALGORITHM_NAME_ECB = "SM4/ECB/";
    private static String ALGORITHM_NAME_CBC = "SM4/CBC/";
    private static String ALGORITHM_NAME_CMAC = "SM4/CBC/PKCS7Padding";
    private static int CBC_KEY_LEN = 16;
    private static String KEY_ALGORITHM = "SM4";
    private static final int hLen = 32;
    private static final BouncyCastleProvider BOUNCY_CASTLE_PROVIDER = new BouncyCastleProvider();

    public static byte[] encryptECB(byte[] text, byte[] key) throws Exception {
        return SM4.encryptECB(text, key, PKCS7_PADDING);
    }

    public static byte[] encryptECB(byte[] text, byte[] key, String padding) throws Exception {
        CIBSMTools.checkStatus();
        SM4.checkPadding(padding);
        if (text == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_ECB + padding, BOUNCY_CASTLE_PROVIDER);
            SecretKeySpec sm4Key = new SecretKeySpec(key, KEY_ALGORITHM);
            cipher.init(1, sm4Key);
            return cipher.doFinal(text);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new Exception("Error code:16001");
        }
    }

    public static byte[] decryptECB(byte[] cipherText, byte[] key) throws Exception {
        return SM4.decryptECB(cipherText, key, PKCS7_PADDING);
    }

    public static byte[] decryptECB(byte[] cipherText, byte[] key, String padding) throws Exception {
        CIBSMTools.checkStatus();
        SM4.checkPadding(padding);
        if (cipherText == null) {
            return null;
        }
        Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_ECB + padding, BOUNCY_CASTLE_PROVIDER);
        SecretKeySpec sm4Key = new SecretKeySpec(key, KEY_ALGORITHM);
        cipher.init(2, sm4Key);
        return cipher.doFinal(cipherText);
    }

    public static byte[] encryptCBC(byte[] text, byte[] iv, byte[] key) throws Exception {
        return SM4.encryptCBC(text, iv, key, PKCS7_PADDING);
    }

    public static byte[] encryptCBC(byte[] text, byte[] iv, byte[] key, String padding) throws Exception {
        CIBSMTools.checkStatus();
        SM4.checkPadding(padding);
        if (text == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_CBC + padding, BOUNCY_CASTLE_PROVIDER);
            SecretKeySpec sm4Key = new SecretKeySpec(key, "SM4");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(1, (Key)sm4Key, ivParameterSpec);
            return cipher.doFinal(text);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new Exception("Error code:16001");
        }
    }

    public static byte[] decryptCBC(byte[] cipherText, byte[] iv, byte[] key) throws Exception {
        return SM4.decryptCBC(cipherText, iv, key, PKCS7_PADDING);
    }

    public static byte[] decryptCBC(byte[] cipherText, byte[] iv, byte[] key, String padding) throws Exception {
        CIBSMTools.checkStatus();
        SM4.checkPadding(padding);
        if (cipherText == null) {
            return null;
        }
        Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_CBC + padding, BOUNCY_CASTLE_PROVIDER);
        SecretKeySpec sm4Key = new SecretKeySpec(key, "SM4");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)sm4Key, ivParameterSpec);
        return cipher.doFinal(cipherText);
    }

    public static byte[] cmac(byte[] text, byte[] iv, byte[] key) throws Exception {
        CIBSMTools.checkStatus();
        if (text == null) {
            return null;
        }
        Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_CMAC, BOUNCY_CASTLE_PROVIDER);
        SecretKeySpec sm4Key = new SecretKeySpec(key, "SM4");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)sm4Key, ivParameterSpec);
        byte[] result = cipher.doFinal(text);
        return Arrays.copyOfRange(result, result.length - 16, result.length - 12);
    }

    public static byte[] keyDerivation(byte[] password, byte[] salt, int iterationTime, int dkLen) throws Exception {
        CIBSMTools.checkStatus();
        int n = SM4.ceil(dkLen, 32);
        byte[] result = null;
        for (int i = 0; i < n; ++i) {
            byte[] ti = null;
            byte[] uc = null;
            for (int c = 0; c < iterationTime; ++c) {
                if (c == 0) {
                    uc = Arrays.concatenate(salt, SM4.intToBytes(i + 1));
                }
                uc = SM3.hmac(uc, password);
                ti = ti == null ? uc : SM4.xor(ti, uc);
            }
            result = Arrays.concatenate(result, ti);
        }
        return Arrays.copyOf(result, dkLen);
    }

    public static byte[] kdfEncryptCBC(byte[] text, byte[] iv, byte[] password, byte[] salt, int iterationTime) throws Exception {
        CIBSMTools.checkStatus();
        byte[] dk = SM4.keyDerivation(password, salt, iterationTime, CBC_KEY_LEN);
        return SM4.encryptCBC(text, iv, dk);
    }

    public static byte[] kdfDecryptCBC(byte[] cipherText, byte[] iv, byte[] password, byte[] salt, int iterationTime) throws Exception {
        CIBSMTools.checkStatus();
        byte[] dk = SM4.keyDerivation(password, salt, iterationTime, CBC_KEY_LEN);
        return SM4.decryptCBC(cipherText, iv, dk);
    }

    public static boolean selfCheck() throws Exception {
        try {
            boolean bool;
            boolean bl = bool = SM4.sm4EcryptEBCTest() && SM4.sm4EcryptCBCTest() && SM4.sm4DecryptEBCTest() && SM4.sm4DecryptCBCTest() && SM4.sm4EbcTest() && SM4.sm4CbcTest();
            if (!bool) {
                throw new Exception("Error code:10004");
            }
        }
        catch (Exception e) {
            throw new Exception("Error code:10004", e);
        }
        return true;
    }

    private static void checkPadding(String padding) throws Exception {
        if (padding != PKCS5_PADDING && padding != PKCS7_PADDING && padding != NOPADDING) {
            throw new Exception("Error code:16002");
        }
    }

    private static int ceil(int x, int y) {
        return x / y + (x % y == 0 ? 0 : 1);
    }

    private static byte[] intToBytes(int i) {
        byte[] result = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    private static byte[] xor(byte[] x, byte[] y) {
        if (x == null || x.length == 0 || y == null || y.length == 0) {
            return x;
        }
        byte[] result = new byte[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = (byte)(x[i] ^ y[i % y.length]);
        }
        return result;
    }

    private static boolean kdfCBCTest() throws Exception {
        String text = "48d23c70a22d4b566f1b9bb97cfa37db";
        String iv = "00000000000000000000000000000000";
        String p = "368c1adba8b9d783";
        String salt = "b4ab70c69fed2e09";
        int c = 1024;
        byte[] cipcher = SM4.kdfEncryptCBC(Hex.decode(text), Hex.decode(iv), Hex.decode(p), Hex.decode(salt), c);
        String result = Hex.toHexString(SM4.kdfDecryptCBC(cipcher, Hex.decode(iv), Hex.decode(p), Hex.decode(salt), c));
        return text.equals(result);
    }

    private static boolean keyDerivationTest() throws Exception {
        String result = "2375a8cbe0137d9cda66aff24ea99c5d632576a6a4ed677eaae2833c06bfbd4f";
        String p = "368c1adba8b9d783";
        String salt = "b4ab70c69fed2e09";
        int c = 1024;
        int dklen = 32;
        byte[] dk = SM4.keyDerivation(Hex.decode(p), Hex.decode(salt), c, dklen);
        return Hex.toHexString(dk).equals(result);
    }

    private static boolean cmacTest() throws Exception {
        String text = "48d23c70a22d4b566f1b9bb97cfa37db";
        String iv = "00000000000000000000000000000000";
        String key = "8b625fa71322d93058150d65c1257701";
        String result = "5D117E57";
        byte[] myresult = SM4.cmac(Hex.decode(text), Hex.decode(iv), Hex.decode(key));
        if (!result.equals(Hex.toHexString(myresult).toUpperCase(Locale.ROOT))) {
            return false;
        }
        text = "48d23c70a22d4b566f1b9bb97cfa37db01";
        iv = "00000000000000000000000000000000";
        key = "8b625fa71322d93058150d65c1257701";
        result = "49D03616";
        myresult = SM4.cmac(Hex.decode(text), Hex.decode(iv), Hex.decode(key));
        if (!result.equals(Hex.toHexString(myresult).toUpperCase(Locale.ROOT))) {
            return false;
        }
        text = "48d23c70a22d4b566f1b9bb97cfa37";
        iv = "00000000000000000000000000000000";
        key = "8b625fa71322d93058150d65c1257701";
        result = "ED684A40";
        myresult = SM4.cmac(Hex.decode(text), Hex.decode(iv), Hex.decode(key));
        return result.equals(Hex.toHexString(myresult).toUpperCase(Locale.ROOT));
    }

    private static boolean sm4EcryptEBCTest() throws Exception {
        String dataValue = "c194e872b807734ca808f7280c14700e";
        String sm4key = "14f1f0fe74169ccf1392974a09030850";
        String sm4iv = "9f9371b18b6badf36e88bf4aa10b9d4f";
        String sm4EbcMw = "46C7E30B49326405E63233FE3C5C626D109DE0EAA38DC7B618D87FC911AC010A";
        String sm4CbcMw = "53CC49D1A9122E1B79B30C03B6C269687421582E8636767D21206E631E7B9350";
        String resultString = SM4.smHashCode(SM4.encryptECB(Hex.decode(dataValue), Hex.decode(sm4key)));
        return sm4EbcMw.equals(resultString);
    }

    private static boolean sm4EcryptCBCTest() throws Exception {
        String dataValue = "c194e872b807734ca808f7280c14700e";
        String sm4key = "14f1f0fe74169ccf1392974a09030850";
        String sm4iv = "9f9371b18b6badf36e88bf4aa10b9d4f";
        String sm4EbcMw = "46C7E30B49326405E63233FE3C5C626D109DE0EAA38DC7B618D87FC911AC010A";
        String sm4CbcMw = "53CC49D1A9122E1B79B30C03B6C269687421582E8636767D21206E631E7B9350";
        String resultString = SM4.smHashCode(SM4.encryptCBC(Hex.decode(dataValue), Hex.decode(sm4iv), Hex.decode(sm4key)));
        return sm4CbcMw.equals(resultString);
    }

    private static boolean sm4DecryptEBCTest() throws Exception {
        String dataValue2 = "a42437452c8c3cd76676264cd80f97fa";
        String sm4key2 = "d3a6a2774ce02f0c429f3799db459427";
        String sm4iv2 = "18bfe2a88f996d36810fe470cb3e8e94";
        String sm4EbcMw2 = "CBD34AA5F4A767B3F9BA2D17A5963B6E83458768E5BB85ED09464077BD324845";
        String sm4CbcMw2 = "C0BB91F70275055488168358098741A9F9EDF9DDA8559C5A50D66FD8F4DAD8E5";
        String resultString = SM4.smHashCode(SM4.decryptECB(Hex.decode(sm4EbcMw2), Hex.decode(sm4key2)), false);
        return dataValue2.equals(resultString);
    }

    private static boolean sm4DecryptCBCTest() throws Exception {
        String dataValue2 = "a42437452c8c3cd76676264cd80f97fa";
        String sm4key2 = "d3a6a2774ce02f0c429f3799db459427";
        String sm4iv2 = "18bfe2a88f996d36810fe470cb3e8e94";
        String sm4EbcMw2 = "CBD34AA5F4A767B3F9BA2D17A5963B6E83458768E5BB85ED09464077BD324845";
        String sm4CbcMw2 = "C0BB91F70275055488168358098741A9F9EDF9DDA8559C5A50D66FD8F4DAD8E5";
        String resultString = SM4.smHashCode(SM4.decryptCBC(Hex.decode(sm4CbcMw2), Hex.decode(sm4iv2), Hex.decode(sm4key2)), false);
        return dataValue2.equals(resultString);
    }

    private static boolean sm4EbcTest() {
        byte[] keyByte = SM4.getRandomByte(16);
        byte[] byteValue16 = SM4.getRandomByte(16);
        byte[] byteValue32 = SM4.getRandomByte(32);
        byte[] byteValue256 = SM4.getRandomByte(256);
        byte[] byteValue1024 = SM4.getRandomByte(1024);
        byte[] byteValue4096 = SM4.getRandomByte(4096);
        boolean resultBoolean = true;
        for (int i = 0; i < 100; ++i) {
            boolean bl = resultBoolean = SM4.sm4EbcTest(byteValue16, keyByte) && SM4.sm4EbcTest(byteValue32, keyByte) && SM4.sm4EbcTest(byteValue256, keyByte) && SM4.sm4EbcTest(byteValue1024, keyByte) && SM4.sm4EbcTest(byteValue4096, keyByte);
            if (!resultBoolean) break;
        }
        return resultBoolean;
    }

    private static boolean sm4CbcTest() throws Exception {
        byte[] keyByte = SM4.getRandomByte(16);
        byte[] byteValue16 = SM4.getRandomByte(16);
        byte[] byteValue32 = SM4.getRandomByte(32);
        byte[] byteValue256 = SM4.getRandomByte(256);
        byte[] byteValue1024 = SM4.getRandomByte(1024);
        byte[] byteValue4096 = SM4.getRandomByte(4096);
        boolean resultBoolean = true;
        for (int i = 0; i < 100; ++i) {
            boolean bl = resultBoolean = SM4.sm4CbcTest(byteValue16, keyByte) && SM4.sm4CbcTest(byteValue32, keyByte) && SM4.sm4CbcTest(byteValue256, keyByte) && SM4.sm4CbcTest(byteValue1024, keyByte) && SM4.sm4CbcTest(byteValue4096, keyByte);
            if (!resultBoolean) break;
        }
        return resultBoolean;
    }

    private static boolean sm4EbcTest(byte[] byteValue, byte[] keyByte) {
        try {
            byte[] ecryptEBCbyte = SM4.encryptECB(byteValue, keyByte);
            byte[] decryptEBCbyte = SM4.decryptECB(ecryptEBCbyte, keyByte);
            String decryptEBCStr = SM4.smHashCode(decryptEBCbyte);
            return SM4.smHashCode(byteValue).equals(decryptEBCStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean sm4CbcTest(byte[] byteValue, byte[] ivByte) throws Exception {
        byte[] key = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -2, -36, -70, -104, 118, 84, 50, 16};
        byte[] ecryptCBCbyte = SM4.encryptCBC(byteValue, ivByte, key);
        byte[] dcryptCBCbyte = SM4.decryptCBC(ecryptCBCbyte, ivByte, key);
        String decryptCBCStr = SM4.smHashCode(dcryptCBCbyte);
        return SM4.smHashCode(byteValue).equals(decryptCBCStr);
    }

    private static byte[] getRandomByte(int length) {
        byte[] bytes = new byte[length];
        new SecureRandom().nextBytes(bytes);
        return bytes;
    }

    private static String smHashCode(byte[] strValue) {
        return Hex.toHexString(strValue).toUpperCase();
    }

    private static String smHashCode(byte[] strValue, boolean bool) {
        if (bool) {
            return Hex.toHexString(strValue).toUpperCase();
        }
        return Hex.toHexString(strValue);
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

