/*
 * Decompiled with CFR 0.152.
 */
package com.cib.smtools.security;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import shade.org.apache.commons.lang3.StringUtils;

public class CommonUtils {
    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.format(date);
    }

    public static Date parseDate(String strDate, String pattern) {
        SimpleDateFormat formatter = null;
        if (StringUtils.isBlank(strDate)) {
            return null;
        }
        formatter = new SimpleDateFormat(pattern);
        try {
            return formatter.parse(strDate);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date dateAdd(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static String fill(String source, int offset, char c, int length) throws UnsupportedEncodingException {
        if (null == source) {
            source = "";
        }
        if (source.getBytes("utf-8").length == length) {
            return source;
        }
        byte[] buf = new byte[length];
        byte[] src = source.getBytes("utf-8");
        if (src.length > length) {
            System.arraycopy(src, src.length - length, buf, 0, length);
            return new String(buf, "utf-8");
        }
        if (offset > src.length) {
            offset = src.length;
        } else if (offset < 0) {
            offset = 0;
        }
        int n = length - src.length;
        System.arraycopy(src, 0, buf, 0, offset);
        for (int i = 0; i < n; ++i) {
            buf[i + offset] = (byte)c;
        }
        System.arraycopy(src, offset, buf, offset + n, src.length - offset);
        return new String(buf, "utf-8");
    }

    public static String replace(String original, int offset, int length, char c) throws UnsupportedEncodingException {
        if (original == null) {
            original = "";
        }
        if (original.getBytes("utf-8").length <= offset) {
            return original;
        }
        if (original.getBytes("utf-8").length < offset + length) {
            length = original.getBytes("utf-8").length - offset;
        }
        byte[] buf = new byte[original.length()];
        byte[] src = original.getBytes("utf-8");
        System.arraycopy(src, 0, buf, 0, offset);
        for (int i = offset; i < offset + length; ++i) {
            buf[i] = (byte)c;
        }
        System.arraycopy(src, offset + length, buf, offset + length, src.length - offset - length);
        return new String(buf, "utf-8");
    }

    public static byte[] hexToByte(String s) {
        byte[] result = null;
        try {
            int i = s.length();
            if (i % 2 != 0) {
                throw new Exception("\u5b57\u7b26\u4e32\u957f\u5ea6\u4e0d\u662f\u5076\u6570.");
            }
            result = new byte[i / 2];
            for (int j = 0; j < result.length; ++j) {
                result[j] = (byte)Integer.parseInt(s.substring(j * 2, j * 2 + 2), 16);
            }
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public static String byte2hexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(bytes[i] & 0xFF, 16));
        }
        return buf.toString().toUpperCase();
    }

    public static byte[] hexString2byte(String hexString) {
        if (null == hexString || hexString.length() % 2 != 0 || hexString.contains("null")) {
            return null;
        }
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length(); i += 2) {
            bytes[i / 2] = (byte)(Integer.parseInt(hexString.substring(i, i + 2), 16) & 0xFF);
        }
        return bytes;
    }

    public static String byte1ToBcd2(int i) {
        return Integer.toString(i / 16) + Integer.toString(i % 16);
    }

    public static String byteToHex2(byte[] b) {
        StringBuffer result = new StringBuffer();
        String tmp = "";
        for (int i = 0; i < b.length; ++i) {
            tmp = Integer.toHexString(b[i] & 0xFF);
            if (tmp.length() == 1) {
                result.append("0" + tmp);
                continue;
            }
            result.append(tmp);
        }
        return result.toString().toUpperCase();
    }

    public static String iso2Gbk(String str) {
        if (null == str) {
            return str;
        }
        try {
            return new String(str.getBytes("ISO-8859-1"), "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    public static long byteToLong(byte[] b) {
        long s = 0L;
        long s0 = b[0] & 0xFF;
        long s1 = b[1] & 0xFF;
        long s2 = b[2] & 0xFF;
        long s3 = b[3] & 0xFF;
        long s4 = b[4] & 0xFF;
        long s5 = b[5] & 0xFF;
        long s6 = b[6] & 0xFF;
        long s7 = b[7] & 0xFF;
        s = s0 | (s1 <<= 8) | (s2 <<= 16) | (s3 <<= 24) | (s4 <<= 32) | (s5 <<= 40) | (s6 <<= 48) | (s7 <<= 56);
        return s;
    }

    public static int byteToInt(byte[] b) {
        int s = 0;
        int s0 = b[0] & 0xFF;
        int s1 = b[1] & 0xFF;
        int s2 = b[2] & 0xFF;
        int s3 = b[3] & 0xFF;
        s = s0 | (s1 <<= 8) | (s2 <<= 16) | (s3 <<= 24);
        return s;
    }

    public static byte[] intToLittleBytes(int i) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asIntBuffer().put(i);
        byte[] littleBytes = byteBuffer.array();
        return littleBytes;
    }

    public static int byteToInt(byte b) {
        int value = b & 0xFF;
        return value;
    }

    public static byte[] byteMerger(byte[] bt1, byte[] bt2) {
        byte[] bt3 = new byte[bt1.length + bt2.length];
        System.arraycopy(bt1, 0, bt3, 0, bt1.length);
        System.arraycopy(bt2, 0, bt3, bt1.length, bt2.length);
        return bt3;
    }
}

