/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.DataSetFindPanelController;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.DataSetFindPanelListener;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;

public class DataSetViewerFindDecorator {
    private IDataSetViewer _dataSetViewer;
    private boolean _putTableInScrollpane;
    private final JSplitPane _split;
    private boolean _findPanelOpen;
    private JScrollPane _scrollPane;
    private DataSetFindPanelController _dataSetFindPanelController;

    public DataSetViewerFindDecorator(IDataSetViewer dataSetViewer, IMessageHandler messageHandler) {
        this(dataSetViewer, true, messageHandler);
    }

    public DataSetViewerFindDecorator(IDataSetViewer dataSetViewer, boolean putTableInScrollpane, IMessageHandler messageHandler) {
        this._dataSetViewer = dataSetViewer;
        this._putTableInScrollpane = putTableInScrollpane;
        this._split = new JSplitPane();
        this._split.setDividerSize(0);
        this._split.setOrientation(0);
        this._split.setDividerLocation(0);
        DataSetFindPanelListener dataSetFindPanelListener = new DataSetFindPanelListener(){

            @Override
            public void hideFindPanel() {
                DataSetViewerFindDecorator.this.toggleShowFindPanel();
            }
        };
        this._dataSetFindPanelController = new DataSetFindPanelController(messageHandler, dataSetFindPanelListener);
        this._dataSetFindPanelController.setDataSetViewerTablePanel((DataSetViewerTablePanel)this._dataSetViewer);
        this._split.setLeftComponent(new NullPanel());
        this._split.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (DataSetViewerFindDecorator.this._split.getLeftComponent() instanceof NullPanel) {
                    DataSetViewerFindDecorator.this._split.setDividerLocation(0);
                }
            }
        });
        if (putTableInScrollpane) {
            this._scrollPane = new JScrollPane();
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this._scrollPane.setViewportView(this._dataSetViewer.getComponent());
            this._split.setRightComponent(this._scrollPane);
        } else {
            this._split.setRightComponent(this._dataSetViewer.getComponent());
        }
    }

    public IDataSetViewer getDataSetViewer() {
        return this._dataSetViewer;
    }

    public Component getComponent() {
        return this._split;
    }

    public boolean toggleShowFindPanel() {
        if (!(this._dataSetViewer instanceof DataSetViewerTablePanel)) {
            return false;
        }
        boolean bl = this._findPanelOpen = !this._findPanelOpen;
        if (this._findPanelOpen) {
            this._split.setLeftComponent(this._dataSetFindPanelController.getPanel());
            this._split.setDividerLocation(this._dataSetFindPanelController.getPanel().getPreferredSize().height);
            this._dataSetFindPanelController.focusTextField();
        } else {
            this._split.setLeftComponent(new NullPanel());
            this._split.setDividerLocation(0);
            this._dataSetFindPanelController.wasHidden();
        }
        return true;
    }

    public void replaceDataSetViewer(IDataSetViewer dataSetViewer) {
        if (null != this._dataSetViewer) {
            this._dataSetViewer.disableContinueRead();
        }
        this._dataSetViewer = dataSetViewer;
        if (this._putTableInScrollpane) {
            this._scrollPane.setViewportView(dataSetViewer.getComponent());
            this._scrollPane.setRowHeader(null);
        } else {
            this._split.setRightComponent(dataSetViewer.getComponent());
        }
        if (this._dataSetViewer instanceof DataSetViewerTablePanel) {
            this._dataSetFindPanelController.setDataSetViewerTablePanel((DataSetViewerTablePanel)this._dataSetViewer);
        } else {
            this._dataSetFindPanelController.setDataSetViewerTablePanel(null);
        }
    }

    public void resetFind() {
        this._dataSetFindPanelController.reset();
    }

    private static class NullPanel
    extends JPanel {
        private NullPanel() {
            this.setPreferredSize(new Dimension(0, 0));
            this.setSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
    }
}

