/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.utils;

import cn.com.syan.jcee.common.impl.utils.CertificateConverter;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DEROctetString;

public class SheCACertificateExtensionUtil {
    private static final String UNIQUE_EXTENSION = "1.2.156.1.8888";
    private static final String IDENTITY_CODE_EXTENSION = "1.2.156.1.8888.148";

    public static String getIdentityCode(String b64Certificate) throws CertificateException {
        String identityCode = null;
        try {
            X509Certificate cert = CertificateConverter.fromBase64(b64Certificate);
            byte[] extBinary = cert.getExtensionValue(UNIQUE_EXTENSION);
            DEROctetString octetString = (DEROctetString)DEROctetString.fromByteArray((byte[])extBinary);
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)octetString.getOctets());
            Iterator iterator = sequence.iterator();
            ASN1Sequence item = null;
            while (iterator.hasNext()) {
                item = (ASN1Sequence)iterator.next();
                ASN1ObjectIdentifier identifier = (ASN1ObjectIdentifier)item.getObjectAt(0);
                if (!identifier.getId().equals(IDENTITY_CODE_EXTENSION)) continue;
                octetString = (DEROctetString)item.getObjectAt(1);
                identityCode = new String(octetString.getOctets());
                break;
            }
        }
        catch (Exception e) {
            throw new CertificateException("\u83b7\u53d6\u8eab\u4efd\u4fe1\u606f\u5931\u8d25\uff0c" + e.getMessage(), e);
        }
        return identityCode;
    }

    public static void main(String[] args) throws Exception {
        String b64Certificate = "MIIFnTCCBIWgAwIBAgIQUUPJHGFT+MEA0bup1vCjTDANBgkqhkiG9w0BAQsFADAzMQswCQYDVQQGEwJDTjERMA8GA1UECgwIVW5pVHJ1c3QxETAPBgNVBAMMCFNIRUNBIEcyMB4XDTE4MDEwNDA3NTEyOFoXDTE4MDQwNDE1NTk1OVowMDELMAkGA1UEBhMCQ04xCzAJBgNVBAMMAmRoMRQwEgYDVQQUEwsxODEyMDE3OTg1NzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMNZMccsFiTOs7vS4gDCStmzqLfZpXogH/b/SqH0431khiX3YWbMeGY8Q/tccs/bN4kfdGJ4VZxhiEf5v8ORvjud4UwGOJk4MMOn2cDYGdR4IRAeFsVRWFB+joI5/97M8sqw+U7+lywvlvC1jTACgliNfa9owrDRqG6Xn8XkyHdP06qedOCvT+68NefJIkKnsLl6jwjqtgBfKpWxAxuxkK4CRHO5ji/AjNOAyfbnAYXs7Z+X+gnaHYOfARLQi+SBe7JpTFQdmR2+faT8WQV/WCt4YpU35b6HE8Vf6b4wYUWWqty8reJvEk9z++wYoevnewC9gk+ygVY1yoQflcyuUC0CAwEAAaOCAq4wggKqMB8GA1UdIwQYMBaAFFaI3uMYQ4K3cqQm60SpYtCHxKwmMB0GA1UdDgQWBBQ2gmj9iGU+pgPbhc/NEmYmFTHdKTALBgNVHQ8EBAMCBsAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMEMEIGA1UdIAQ7MDkwNwYJKoEcAYbvOoEVMCowKAYIKwYBBQUHAgEWHGh0dHA6Ly93d3cuc2hlY2EuY29tL3BvbGljeS8wCQYDVR0TBAIwADB9BggrBgEFBQcBAQRxMG8wOAYIKwYBBQUHMAGGLGh0dHA6Ly9vY3NwMy5zaGVjYS5jb20vb2NzcC9zaGVjYS9zaGVjYS5vY3NwMDMGCCsGAQUFBzAChidodHRwOi8vbGRhcDIuc2hlY2EuY29tL3Jvb3Qvc2hlY2FnMi5kZXIwgdwGA1UdHwSB1DCB0TA1oDOgMYYvaHR0cDovL2xkYXAyLnNoZWNhLmNvbS9DQTIwMDExL1JBOTAzMS9DUkwxMS5jcmwwgZeggZSggZGGgY5sZGFwOi8vbGRhcDIuc2hlY2EuY29tOjM4OS9jbj1DUkwxMS5jcmwsb3U9UkE5MDMxLG91PUNBMjAwMTEsb3U9Y3JsLG89VW5pVHJ1c3Q/Y2VydGlmaWNhdGVSZXZvY2F0aW9uTGlzdD9iYXNlP29iamVjdENsYXNzPWNSTERpc3RyaWJ1dGlvblBvaW50MIGOBgYqgRwBxTgEgYMwgYAwSQYIKoEcAcU4gRAEPWxkYXA6Ly9sZGFwMi5zaGVjYS5jb20vb3U9c2hlY2EgY2VydGlmaWNhdGUgY2hhaW4sbz1zaGVjYS5jb20wEQYIKoEcAcU4gRMEBTY2MDU1MCAGCCqBHAHFOIEUBBRTRjMyMDExMzE5OTIxMDI4MDQxMTANBgkqhkiG9w0BAQsFAAOCAQEAVcRvQBUpnVSY2COA6p7gcRTmkg9ZLty+4mQeklC+p1AnLMS3iSqSf86BAHfDHtCWV+vCLW42P4+Xc/Rvwd5/r/c0+KwsrTOocehQkor/NsizDif9bcqktNHKLLtuiD6+HQq4UxYiomqmbNJjjiYEg157NuNWWMK/G2x5huIikMAuaIyBl9+mJEyWMRd2uQAKLHnNDdxLWq+hJ/XWwv0cMTDuSCqfu9f2rdg/97EkZ17EnZVoCxnJ8Ou8DXoAnOf/DH8HTFtz7IJVGaoMDOZdimyCZCbwA2G/ODnj/HJGaODy/cO/QxqNC6JyqHXe4S4a53yAxxhClp2/nzRzmczobg==";
        String identityTypeAndCode = SheCACertificateExtensionUtil.getIdentityCode(b64Certificate);
        if (identityTypeAndCode != null) {
            String identityType = identityTypeAndCode.substring(0, 2);
            String identityCode = identityTypeAndCode.substring(2);
            System.out.println("identity type=" + identityType);
            System.out.println("identity code=" + identityCode);
        }
    }
}

