/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.utils;

import cn.com.syan.jcee.common.impl.key.ECDomainParametersHelper;
import cn.com.syan.jcee.common.impl.key.RSAPrivateKeyGenerator;
import cn.com.syan.jcee.common.impl.key.SM2BCPublicKey;
import cn.com.syan.jcee.common.impl.key.SparkECPrivateKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.util.Enumeration;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DERBitString;
import org.spongycastle.asn1.DERNull;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERTaggedObject;
import org.spongycastle.crypto.params.ECPrivateKeyParameters;
import org.spongycastle.crypto.params.ECPublicKeyParameters;
import org.spongycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.spongycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.spongycastle.jce.provider.BouncyCastleProvider;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.util.encoders.Base64;

public final class PrivateKeyBuilder {
    public static PrivateKey buildPrivateKey(String base64KeyValue) throws InvalidKeyException {
        return PrivateKeyBuilder.buildPrivateKey(Base64.decode((String)base64KeyValue));
    }

    public static PrivateKey buildPrivateKey(byte[] binaryKeyValue, String provider) throws InvalidKeyException {
        return RSAPrivateKeyGenerator.buildPrivateKey(binaryKeyValue, provider);
    }

    public static PrivateKey buildPrivateKey(byte[] binaryKeyValue) throws InvalidKeyException {
        return RSAPrivateKeyGenerator.buildPrivateKey(binaryKeyValue);
    }

    public static SparkECPrivateKey buildSparkECPrivateKey(String keyValue) throws InvalidKeyException {
        byte[] pkb = Base64.decode((String)keyValue);
        return PrivateKeyBuilder.buildSparkECPrivateKey(pkb);
    }

    public static BCECPrivateKey buildBCECPrivateKey(byte[] privateKey) {
        BigInteger userD = new BigInteger(1, privateKey);
        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(userD, ECDomainParametersHelper.getECDomainParameters());
        return new BCECPrivateKey("1.2.156.10197.1.301", ecPrivateKeyParameters, BouncyCastleProvider.CONFIGURATION);
    }

    public static SparkECPrivateKey buildSparkECPrivateKey(byte[] asn1EncodedKeyValue) throws InvalidKeyException {
        SparkECPrivateKey sparkECPrivateKey = new SparkECPrivateKey();
        BCECPrivateKey privateKey = null;
        try {
            ASN1Sequence pkPEMSequence = ASN1Sequence.getInstance((Object)asn1EncodedKeyValue);
            DEROctetString octetValue = (DEROctetString)DEROctetString.getInstance((Object)pkPEMSequence.getObjectAt(2));
            ASN1Sequence pkSequence = ASN1Sequence.getInstance((Object)octetValue.getOctets());
            DEROctetString sm2PrivateKeyValue = null;
            Enumeration enu = pkSequence.getObjects();
            SM2BCPublicKey sm2BCPublicKey = null;
            while (enu.hasMoreElements()) {
                Object obj = enu.nextElement();
                if (obj instanceof DEROctetString) {
                    sm2PrivateKeyValue = (DEROctetString)obj;
                }
                if (!(obj instanceof DERTaggedObject)) continue;
                DERTaggedObject pubObj = (DERTaggedObject)obj;
                String xxx = Base64.toBase64String((byte[])pubObj.getEncoded());
                if (pubObj.getObject() instanceof DERNull || !(pubObj.getObject() instanceof DERBitString)) continue;
                DERBitString pub = DERBitString.getInstance((Object)pubObj.getObject());
                sm2BCPublicKey = new SM2BCPublicKey(pub.getBytes());
            }
            BigInteger userD = null;
            if (sm2PrivateKeyValue != null) {
                userD = new BigInteger(1, sm2PrivateKeyValue.getOctets());
            }
            if (sm2BCPublicKey == null) {
                ECPoint userKey = ECDomainParametersHelper.getECPointG().multiply(userD);
                sm2BCPublicKey = new SM2BCPublicKey(userKey);
            }
            ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(sm2BCPublicKey.getQ(), ECDomainParametersHelper.getECDomainParameters());
            BCECPublicKey publicKey = new BCECPublicKey("1.2.156.10197.1.301", ecPublicKeyParameters, ECDomainParametersHelper.getECParameterSpec(), BouncyCastleProvider.CONFIGURATION);
            ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(userD, ECDomainParametersHelper.getECDomainParameters());
            privateKey = new BCECPrivateKey("1.2.156.10197.1.301", ecPrivateKeyParameters, BouncyCastleProvider.CONFIGURATION);
            sparkECPrivateKey.setECPublicKey(publicKey);
            sparkECPrivateKey.setECPrivateKey(privateKey);
        }
        catch (Exception ex) {
            throw new InvalidKeyException("failed to build syan ec private key, cause: " + ex.getMessage());
        }
        return sparkECPrivateKey;
    }
}

