/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.utils;

import cn.com.syan.jcee.common.impl.x509.SM2X509Certificate;
import cn.com.syan.jcee.utils.StringFormatHelper;
import cn.com.syan.jcee.utils.codec.binary.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.spongycastle.cert.X509CertificateHolder;

public class CertificateConverter {
    public static String toPEMString(String x509Certificate) throws IOException {
        return StringFormatHelper.toPEMString((String)x509Certificate, (int)1);
    }

    public static String toPEMString(X509Certificate x509Certificate) throws CertificateEncodingException {
        return StringFormatHelper.toPEMString((X509Certificate)x509Certificate);
    }

    public static String toBase64String(X509Certificate x509Certificate) throws CertificateEncodingException {
        return Base64.encodeBase64String((byte[])x509Certificate.getEncoded());
    }

    public static X509Certificate fromBase64(String data) throws CertificateException {
        return CertificateConverter.fromBinary(Base64.decodeBase64((String)data.trim()));
    }

    public static X509Certificate fromBase64(byte[] data) throws CertificateException {
        return CertificateConverter.fromBinary(Base64.decodeBase64((byte[])data));
    }

    public static X509Certificate fromBinary(byte[] data) throws CertificateException {
        try {
            X509CertificateHolder holder = new X509CertificateHolder(data);
            String publicKeyAlgorithm = holder.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().getId();
            if ("1.2.840.10045.2.1".equals(publicKeyAlgorithm)) {
                return new SM2X509Certificate(holder.toASN1Structure());
            }
        }
        catch (IOException e) {
            throw new CertificateException("failed to parse certificate");
        }
        ByteArrayInputStream ins = new ByteArrayInputStream(data);
        return CertificateConverter.fromInputStream(ins);
    }

    public static X509Certificate fromInputStream(InputStream data) throws CertificateException {
        if (data == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(data);
    }

    public static X509Certificate fromPEMString(String data) throws CertificateException {
        String sep = "-----";
        String header = "-----BEGIN CERTIFICATE-----";
        String clearData = data.trim().replace("\n", "").replace("\r", "");
        if (!clearData.contains(header)) {
            throw new IllegalArgumentException("invalid pem certificate");
        }
        String[] values = clearData.split(sep);
        if (4 != values.length) {
            throw new IllegalArgumentException("invalid pem certificate");
        }
        return CertificateConverter.fromBase64(values[2]);
    }
}

