/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.utils;

import cn.com.syan.jcee.common.impl.x509.SM2X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.cert.X509CertificateHolder;
import org.spongycastle.util.encoders.Base64;

public final class CertificateBuilder {
    public static X509Certificate buildCertificate(byte[] x509Binary) throws CertificateException {
        try {
            X509CertificateHolder holder = new X509CertificateHolder(x509Binary);
            AlgorithmIdentifier identifier = holder.getSignatureAlgorithm();
            if (identifier.getAlgorithm().getId().equals("1.2.156.10197.1.501")) {
                return new SM2X509Certificate(holder.toASN1Structure());
            }
        }
        catch (IOException e) {
            throw new CertificateException("failed to parse certificate");
        }
        ByteArrayInputStream ins = new ByteArrayInputStream(x509Binary);
        return CertificateBuilder.buildCertificate(ins);
    }

    public static X509Certificate buildCertificate(InputStream ins) throws CertificateException {
        X509Certificate x509cert = null;
        try {
            if (ins == null) {
                throw new CertificateException("build Certificate failed.");
            }
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            x509cert = (X509Certificate)factory.generateCertificate(ins);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return x509cert;
    }

    public static X509Certificate buildCertificate(String certValue) throws CertificateException {
        return CertificateBuilder.buildCertificate(Base64.decode((String)certValue));
    }

    public static CertPath buildCertificatePath(InputStream ins) throws CertificateException {
        CertPath path = null;
        boolean buildResult = false;
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        try {
            if (ins != null) {
                while (ins.available() > 0) {
                    path = factory.generateCertPath(ins, "PKCS7");
                    buildResult = true;
                }
                ins.close();
            }
            if (!buildResult) {
                throw new CertificateException();
            }
        }
        catch (IOException e) {
            throw new CertificateException();
        }
        return path;
    }

    public static CertPath buildCertificatePath(byte[] pathBinary) throws CertificateException {
        CertPath path = null;
        ByteArrayInputStream ins = null;
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            ins = new ByteArrayInputStream(pathBinary);
            path = factory.generateCertPath(ins, "PKCS7");
        }
        catch (Exception e) {
            throw new CertificateException("Failed to build P7B Certificate path.");
        }
        finally {
            if (ins != null) {
                try {
                    ins.reset();
                    ins.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return path;
    }

    public static X509CRL buildX509Crl(byte[] crlBinary) throws CRLException {
        CertificateFactory fac;
        ByteArrayInputStream ins = null;
        try {
            fac = CertificateFactory.getInstance("X.509");
            ins = new ByteArrayInputStream(crlBinary);
        }
        catch (Exception ex) {
            throw new CRLException("Failed to build X.509 CRL");
        }
        finally {
            if (ins != null) {
                try {
                    ins.reset();
                    ins.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return (X509CRL)fac.generateCRL(ins);
    }
}

