/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.pkcs7.envelope;

import cn.com.syan.jcee.common.impl.SparkCipher;
import cn.com.syan.jcee.common.impl.ecc.cipher.SM4SymmetricCipher;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.RecipientOperator;
import org.spongycastle.cms.jcajce.JceKeyTransRecipient;
import org.spongycastle.jcajce.io.CipherInputStream;
import org.spongycastle.operator.InputDecryptor;

public class SparkKeyTransEnvelopedRecipient
extends JceKeyTransRecipient {
    private PrivateKey privateKey;
    private InputDecryptor inputDecryptor = null;

    public SparkKeyTransEnvelopedRecipient(PrivateKey recipientKey) {
        super(recipientKey);
        this.privateKey = recipientKey;
    }

    public SparkKeyTransEnvelopedRecipient(InputDecryptor inputDecryptor) {
        super(null);
        this.privateKey = null;
        this.inputDecryptor = inputDecryptor;
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        RecipientOperator recipientOperator = null;
        final Key secretKey = keyEncryptionAlgorithm.getAlgorithm().getId().equals("1.2.156.10197.1.301.3") ? this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey) : super.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey);
        String getAlgorithm = secretKey.getAlgorithm();
        if (getAlgorithm.startsWith("SM4") || getAlgorithm.startsWith("1.2.156.10197.1.104")) {
            recipientOperator = new RecipientOperator(new InputDecryptor(){

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return contentEncryptionAlgorithm;
                }

                public InputStream getInputStream(InputStream dataIn) {
                    return this.doDecrypt(dataIn);
                }

                private InputStream doDecrypt(InputStream dataIn) {
                    try {
                        DEROctetString iv = (DEROctetString)contentEncryptionAlgorithm.getParameters();
                        SM4SymmetricCipher sm4Cipher = SM4SymmetricCipher.getInstance(secretKey.getAlgorithm());
                        sm4Cipher.init(0, secretKey.getEncoded(), iv.getOctets());
                        byte[] data = IOUtils.toByteArray((InputStream)dataIn);
                        sm4Cipher.update(data);
                        byte[] plainData = sm4Cipher.doFinal();
                        return new ByteArrayInputStream(plainData);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
        } else {
            final Cipher dataCipher = this.contentHelper.createContentCipher(secretKey, contentEncryptionAlgorithm);
            recipientOperator = new RecipientOperator(new InputDecryptor(){

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return contentEncryptionAlgorithm;
                }

                public InputStream getInputStream(InputStream dataIn) {
                    return new CipherInputStream(dataIn, dataCipher);
                }
            });
        }
        return recipientOperator;
    }

    protected Key extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedEncryptionKey) throws CMSException {
        SecretKeySpec secretKey = null;
        try {
            if (this.privateKey != null) {
                SparkCipher sparkCipher = SparkCipher.getInstance("SM2");
                sparkCipher.init(2, this.privateKey);
                sparkCipher.update(encryptedEncryptionKey);
                byte[] encryptionKey = sparkCipher.doFinal();
                secretKey = new SecretKeySpec(encryptionKey, "AES");
            } else {
                InputStream cipherStream = new ByteArrayInputStream(encryptedEncryptionKey);
                cipherStream = this.inputDecryptor.getInputStream(cipherStream);
                secretKey = new SecretKeySpec(IOUtils.toByteArray((InputStream)cipherStream), "AES");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CMSException("exception unwrapping key: " + e.getMessage(), e);
        }
        return secretKey;
    }
}

